#include "obgtkAcceleratorTable.h"
#include "obgtkObject.h"

@implementation Gtk_AcceleratorTable
{
@public
  GtkAcceleratorTable *gtkacceleratortable;
}
- init
{
  self = [super init];
  gtkacceleratortable = gtk_accelerator_table_new();
  [self ref];
  return self;
}

- ref
{
  gtk_accelerator_table_ref(gtkacceleratortable);
  return self;
}

- unref
{
  gtk_accelerator_table_unref(gtkacceleratortable);
  return self;
}

- free
{
  [self unref];
  return [super free];
}

- install:(id) gtk_object
	 :(const gchar *) signal_name
	 :(guchar) accelerator_key
	 :(guint8) accelerator_mods
{
  gtk_accelerator_table_install(gtkacceleratortable,
				[gtk_object getGtkObject],
				signal_name,
				accelerator_key,
				accelerator_mods);
  return self;
}

- remove   :(id) gtk_object
 signalName:(const char *) signal_name
{
  gtk_accelerator_table_remove(gtkacceleratortable, [gtk_object getGtkObject],
			       signal_name);
  return self;
}

- (gint) check:(const guchar) accelerator_key
	      :(guint8) accelerator_mods
{
  return gtk_accelerator_table_check(gtkacceleratortable, accelerator_key,
				     accelerator_mods);
}

- set_mod_mask:(guint8) modifier_mask
{
  gtk_accelerator_table_set_mod_mask(gtkacceleratortable, modifier_mask);
  return self;
}
@end
