/*
 * GWT - General Windowing Toolkit
 *
 * Copyright (C) 1998 MenTaLguY - mentalg@geocities.com
 *                    Rodolphe Ortalo - ortalo@laas.fr
 *                    Tristan Wibberley - twibberley@llamacom.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: gwt.h,v $
 * Revision 1.5  1998/09/02 02:21:59  tristan
 * Loadsa great stuff done. Visible/invalid regions,
 *  copy on move - fixed tt_region.c too!
 *
 * Revision 1.4  1998/08/23 18:57:20  ortalo
 * Minor editing (mainly comments).
 *
 * Revision 1.3  1998/08/16 18:41:02  ortalo
 * A new version, STILL IN VERY ALPHA STATE... (Be patient.)
 * (However, this version is a little better... :-)
 *
 * Revision 1.2  1998/08/15 16:15:02  marcus
 * Fixed a typo
 *
 * Revision 1.1  1998/08/11 22:13:59  ortalo
 * Filename change (in include/) gwt.h -> ggi/gwt.h
 *
 * Revision 1.2  1998/08/11 22:09:10  ortalo
 * Incorporated the work made by Tristan Wibberley. Still in alpha
 * development state.
 *
 * Revision 1.1  1998/07/09 18:38:39  ortalo
 * Initial integration of libgwt in the GGI repository.
 * This is experimental code, for your eyes only !
 * (Don't execute... ;-)
 *
 */

#ifndef __GGI_GWT_H
#define __GGI_GWT_H

#include <ggi/ggi.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _BUILDING_LIBGWT
typedef void *gwt_window_t;
typedef void *gwt_region_t;
#endif

/*
 * Library initialisation and shutdown
 */
int gwtInit(void);
int gwtExit(void);
int gwtAttach(ggi_visual_t vis);
int gwtDetach(ggi_visual_t vis);

/*
 * Window creation/destruction
 */
int gwtCreateWindow(gwt_window_t wparent, gwt_window_t *win);
int gwtDestroy(gwt_window_t win);
/* Root Window: special case */
int gwtCreateRootWindow(ggi_visual_t vis, gwt_window_t *win);

/*
 * Z-Order management and access functions
 */
int gwtRaise(gwt_window_t win, gwt_window_t above);
int gwtLower(gwt_window_t win, gwt_window_t below);
int gwtGetTopChild(gwt_window_t win, gwt_window_t *top);
int gwtGetBottomChild(gwt_window_t win, gwt_window_t *bottom);
int gwtGetPrevChild(gwt_window_t win, gwt_window_t *prev);
int gwtGetNextChild(gwt_window_t win, gwt_window_t *next);

/*
 * Windows hierarchy manipulation
 * (NB: The Z-Order provides the access functions.)
 */
int gwtGetParent(gwt_window_t win, gwt_window_t *parent);
int gwtReparent(gwt_window_t win, gwt_window_t newparent);

/*
 * Region manipulation functions
 *   Can we clarify the specified behaviour of these? I'm currently assuming
 *   that the regions for returning values must be created before trying to use
 *   them -- Tristan
 */
int gwtRegionCreate(gwt_region_t *region);
int gwtRegionIsEmpty(gwt_region_t region);
int gwtRegionCopy(gwt_region_t dest, gwt_region_t src);
int gwtRegionUnion(gwt_region_t u, gwt_region_t r1, gwt_region_t r2);
int gwtRegionIntersection(gwt_region_t isect, gwt_region_t r1, gwt_region_t r2);
int gwtRegionDifference(gwt_region_t diff, gwt_region_t r1, gwt_region_t r2);
/* A new function, with the new consistent types (_t), a region is no longer auto */
void gwtRegionDestroy(gwt_region_t region);

/* Access to the GGI visual of a GWT window (if needed) */
int gwtGetVisual(gwt_window_t win, ggi_visual_t *vis);

/*
 * Private data pointer access
 */
int gwtGetPrivate(gwt_window_t win, void* *priv);
int gwtSetPrivate(gwt_window_t win, void* priv);
#if 0
/*
 * Windows ID system
 */
/* TODO: To be implemented (id.c). */
gwt_id_t gwtGetID(gwt_window_t win);
gwt_window_t gwtGetFromID(gwt_id_t id);
#endif
/*
 * Show/Hide functions
 */
int gwtShow(gwt_window_t win);
int gwtHide(gwt_window_t win);
int gwtIsHidden(gwt_window_t win);	/* explicility hidden? */
int gwtIsVisible(gwt_window_t win);	/* not implicitly or explicitly hidden, new. */

/*
 * Windows geometry manipulation
 */
int gwtMove(gwt_window_t win, int x, int y);
int gwtResize(gwt_window_t win, int w, int h);
int gwtSetGeometry(gwt_window_t win, int x, int y, int w, int h);
int gwtGetRegion(gwt_window_t win, gwt_region_t region);
int gwtGetInvalidRegion(gwt_window_t win, gwt_region_t region);
int gwtGetVisibleRegion(gwt_window_t win, gwt_region_t region);
/* Here is my idea for the rectangle iterator I suggested, feel free to delete it */
int gwtIterateRect(gwt_region_t region, int *rectno,
			ggi_coord *origin, ggi_coord *size);
int gwtRectMapOrigin(ggi_coord *origin, gwt_window_t win);

int gwtValidate(gwt_window_t);

#if 0
/*
 * Event queue system
 */
int gwtEventQueueCreate(gwt_evqueue_t *queue);
int gwtEventQueueDestroy(gwt_evqueue_t queue);
int gwtEventPost(ggi_event *event, gwt_evqueue_t queue);
int gwtEventDeliver(ggi_event *event, gwt_window_t win);
int gwtEventProcess(ggi_event *event, gwt_window_t win);
int gwtEventDiscard(gwt_evqueue_t queue, ggi_event_mask type, gwt_window_t win);
int gwtEventGet(ggi_event *event, gwt_window_t *recipient, gwt_evqueue_t queue, ggi_event_mask accept);
int gwtEventGetSelectFileDesc(gwt_evqueue_t queue);
/* TODO: To be implemented */
int gwtEventPoll(gwt_evqueue_t queue, ggi_event_mask accept, struct timeval *timeout);

/* TODO: To be implemented... */
int gwtEventSetQueue(gwt_evqueue_t queue, gwt_window_t win);
int gwtEventGetQueue(gwt_evqueue_t *queue, gwt_window_t win);
int gwtEventSetMask(ggi_event_mask mask, gwt_window_t win);
int gwtEventGetMask(ggi_event_mask *mask, gwt_window_t win);
#endif
/*
 * Temporary drawing functions to help debug
 */

int gwtDrawPixel(gwt_window_t win, int x, int y);
int gwtPutPixel(gwt_window_t win, int x, int y, ggi_pixel pixel);
int gwtDrawFrame(gwt_window_t win);
int gwtDrawRect(gwt_window_t win);
int gwtFillscreen(gwt_window_t win);

#if 0

/************************** (Nice) Legacy *****************************/
/* TODO: Finish the adaptation */
 
int gwt_set_geometry(gwt_window_t win, sint16 x, sint16 y, uint16 width, uint16 height);
int gwt_move(gwt_window_t win, sint16 x, sint16 y);
int gwt_resize(gwt_window_t win, uint16 width, uint16 height);

int gwt_invalidate_all(gwt_window_t win);
int gwt_validate_all(gwt_window_t win);
int gwt_invalidate(gwt_window_t win, gwt_region *region);
int gwt_validate(gwt_window_t win, gwt_region *region);
int gwt_get_invalid_region(gwt_region *region, gwt_window_t win);

int gwt_get_region(gwt_region *region, gwt_window_t win, gwt_window_t relative_to);
int gwt_translate_point(gwt_point *dest, gwt_window_t from, gwt_window_t to, gwt_point *pt);
#endif

#ifdef __cplusplus
} /* of extern "C" */
#endif

#endif /* __GGI_GWT_H */
