
#include <ggi/ggi.h>
#include <ggi/gwt.h>
#include <stdio.h>

ggi_pixel white, dwhite, red, dred, black, green, dgreen, blue, dblue;

#define REDRAW \
	ggiSetGCForeground(vis, white); \
	gwtFillscreen(rootwin); \
	ggiSetGCForeground(vis, green); \
	gwtFillscreen(subwin2); \
	ggiSetGCForeground(vis, blue); \
	gwtFillscreen(subwin3); \
	ggiSetGCForeground(vis, red); \
	gwtFillscreen(subwin); \
	ggiSetGCForeground(vis, dwhite); \
	gwtDrawRect(rootwin); \
	ggiSetGCForeground(vis, dgreen); \
	gwtDrawRect(subwin2); \
	ggiSetGCForeground(vis, dblue); \
	gwtDrawRect(subwin3); \
	ggiSetGCForeground(vis, dred); \
	gwtDrawRect(subwin); \
	ggiFlush(vis)


int main(int argc, char ** argv)
{
	int key;
	int wx=64, wy=0, s=128, d=4;
	int finished=0;

	ggi_visual_t vis;
	ggi_mode tm;
	gwt_window_t rootwin, subwin, subwin2, subwin3;
	ggi_color col;

	ggiInit();
	gwtInit();
	vis=ggiOpen(NULL);
	gwtAttach(vis);
	
	ggiCheckGraphMode(vis, GT_AUTO, GT_AUTO, GT_AUTO, GT_AUTO, GT_AUTO, &tm);
	ggiSetMode(vis, &tm);

	col.r=col.g=col.b=0x0000;
	black=ggiMapColor(vis, &col);

	col.r=col.g=col.b=0x7fff;
	white=ggiMapColor(vis, &col);
	col.r=col.g=col.b=0xffff;
	dwhite=ggiMapColor(vis, &col);

	col.g=col.b=0x0; col.r=0x7fff;
	red=ggiMapColor(vis, &col);
	col.g=col.b=0x0; col.r=0xffff;
	dred=ggiMapColor(vis, &col);

	col.r=col.b=0x0000; col.g=0x7fff;
	green=ggiMapColor(vis, &col);
	col.r=col.b=0x0000; col.g=0xffff;
	dgreen=ggiMapColor(vis, &col);

	col.g=col.r=0x0000; col.b=0x7fff;
	blue=ggiMapColor(vis, &col);
	col.g=col.r=0x0000; col.b=0xffff;
	dblue=ggiMapColor(vis, &col);

	gwtCreateRootWindow(vis, &rootwin);
	gwtCreateWindow(rootwin, &subwin);
	gwtCreateWindow(rootwin, &subwin2);
	gwtCreateWindow(rootwin, &subwin3);


	gwtSetGeometry(subwin2, wx, wy, s, s);
	gwtSetGeometry(subwin, 16, 16, 64, 64);
	gwtSetGeometry(subwin3, 48, 48, 64, 64);
	gwtShow(subwin);
	gwtShow(subwin2);
	gwtShow(subwin3);

do {
	REDRAW;
	gwtValidate(rootwin);
	gwtValidate(subwin);
	gwtValidate(subwin2);
	gwtValidate(subwin3);
	
	do key = ggiGetc(vis);
	while ((key == GGI_KEY_VOID) || (GGI_KTYP(key) == GGI_KT_SHIFT));

	switch (key) {
	case 'q':		/* up*/
		wy-=d; break;
	case 'a':		/* down */
		wy+=d; break;
	case 'o':		/* left */
		wx-=d; break;
	case 'p':		/* right */
		wx+=d; break;
	case 't':		/* Toggle hidden */
		if (gwtIsHidden(subwin2)) gwtShow(subwin2);
		else gwtHide(subwin2);
		break;
	case ' ':		/* finish */
		finished=1; break;
	case '=':
		s+=d; break;
	case '-':
		s-=d; break;
	}
	gwtSetGeometry(subwin2, wx, wy, s, s);
} while (!finished);

	ggiFlush(vis);

	gwtDestroy(rootwin);	/* closes children first */
	gwtDetach(vis);
	ggiClose(vis);
	gwtExit();
	ggiExit();
	exit(0);
}

