/* $Id: init.c,v 1.2 1998/10/24 04:04:09 marcus Exp $
***************************************************************************

   LibGII initialization.

   Copyright (C) 1997 Jason McMullan	[jmcc@ggi-project.org]
   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include <ggi/internal/gii.h>

/* Global variables */
uint32                _giiDebugState = 0;
int                   _giiDebugSync = 0;
void                 *_giiconfhandle = NULL;

/* Static variables */
static int 	      _giiLibIsUp =0 ;
static char           giiconfstub[512] = GIICONFFILE;
static char          *giiconffile = giiconfstub+4;
static int            numextensions = 0;

/*
 * Initalize the strutures for the library
 */

int giiInit(void)
{
	int err;
	const char *str;
	
	_giiLibIsUp++;
	if (_giiLibIsUp>1) return 0;	/* Initialize only at first call. */

	str=getenv("GII_DEBUG");
	if (str!=NULL) {
		_giiDebugState=atoi(str);
		DPRINT_CORE("Debugging=%d\n",_giiDebugState);
	}

	str=getenv("GII_DEBUGSYNC");
	if (str!=NULL) {
		_giiDebugSync=1;
	}
		
	err = ggLoadConfig(giiconffile, &_giiconfhandle);
	if (err == GGI_OK)
		return GGI_OK;

	fprintf(stderr, "LibGII: couldn't load %s\n", giiconffile);

	_giiLibIsUp--;
	return err;
}

int giiExit(void)
{
	DPRINT_CORE("giiExit called\n");
	if (!_giiLibIsUp)
		return -1;

	if (_giiLibIsUp > 1) {
		_giiLibIsUp--;
		return _giiLibIsUp;
	}

	DPRINT_CORE("giiExit: really destroying.\n");
	/* Fixme close all inputs */
	
	ggFreeConfig(_giiconfhandle);
	_giiLibIsUp=0;

	DPRINT_CORE("giiExit: done!\n");
	return 0;
}

