/* $Id: debug.c,v 1.1 1998/10/24 04:04:10 marcus Exp $
***************************************************************************

   LibGG - Debug output

   Copyright (C) 1997 Todd Fries	[toddf@acm.org]
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdarg.h>

#include <ggi/gg.h>
#include "plat.h"

#ifndef __GNUC__
void DPRINT(int sync, const char *form,...)
{
	va_list args;

	va_start(args, form);
	vfprintf(stderr,form,args);
	va_end(args);
}
#endif /* !__GNUC__ */

void ggDPrintf(int sync, const char *file, int line, const char *form,...)
{
	va_list args;

	va_start(args, form);
	fprintf(stderr,"libggi: %s:%i: ",file,line);
	vfprintf(stderr,form,args);
	if (sync) {
		fflush(stderr);
	}
	va_end(args);
}
