/* 
 *  line drawing
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"
#include "util.h"

/*----------------------------------------------------------------------*/

static void	line(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2)
{
	void 	(*drawPixel)(ggi_visual_t, ggi_s, ggi_s)
		= GGI2D_FUNC(vis)->drawPixel;

#define HLINE(x1, x2, y)	GGI2D_FUNC(vis)->hLine(vis, x1, x2, y)
#define VLINE(x, y1, y2)	GGI2D_FUNC(vis)->vLine(vis, x, y1, y2)
#define PLOT(x, y)		drawPixel(vis, x, y)

#include "template/line.h"
}

static void	line_st(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2)
{
}

void	(*GGIEXP(line)[4])(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2) =
{
	line,
	line_st
};

/*----------------------------------------------------------------------*/

void	GGIEXP(drawLines)(ggi_visual_t vis, ggi2d_line lines[], ggi_uint count)
{
	int	i;
	void 	(*line)(ggi_visual_t, int, int, int, int) 
		= GGI2D_FUNC(vis)->line;
    
	for (i = 0; i < count; i++)
		line(vis, lines[i].x1, lines[i].y1, lines[i].x2, lines[i].y2);
}

/*----------------------------------------------------------------------*/
