/* 
 *  Library internal declarations
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _LIB_H_
#define _LIB_H_

#include "ggi2dlib.h"

void	GGIEXP(putPixel)(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel col);
void	GGIEXP(drawPixel)(ggi_visual_t vis, ggi_sint x, ggi_sint y);
void	(*GGIEXP(fillPixel)[2])(ggi_visual_t vis, ggi_sint x, ggi_sint y);
void	GGIEXP(scanline)(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y);
void	GGIEXP(drawPixels)(ggi_visual_t vis, ggi2d_coord coords[], ggi_uint count);
void	GGIEXP(scanlines)(ggi_visual_t vis, ggi2d_scanline scanlines[], ggi_uint count);
void	GGIEXP(drawLines)(ggi_visual_t vis, ggi2d_line lines[], ggi_uint count);
void	(*GGIEXP(hLine)[2])(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y);
void	(*GGIEXP(vLine)[2])(ggi_visual_t vis, ggi_sint x, ggi_sint y1, ggi_sint y2);
void	(*GGIEXP(drawRect)[2])(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2);
void	GGIEXP(fillRect)(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2);
void	(*GGIEXP(line)[2])(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2);
void	(*GGIEXP(drawCircle)[2])(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint r);
void	GGIEXP(fillCircle)(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint r);
void	(*GGIEXP(drawEllipse)[2])(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint a, ggi_uint b);
void	GGIEXP(fillEllipse)(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint a, ggi_uint b);
void	(*GGIEXP(drawArc)[2])(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint a, ggi_uint b,
	    	   ggi_float start, ggi_float end, int close);
void	GGIEXP(fillArc)(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint a, ggi_uint b,
		   ggi_float start, ggi_float end);
void	(*GGIEXP(bezier)[2])(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2, 
			ggi_sint x3, ggi_sint y3, ggi_sint x4, ggi_sint y4);
void	GGIEXP(trapezoid)(ggi_visual_t vis, ggi_sint xl1, ggi_sint xr1, ggi_sint y1, ggi_sint xl2, ggi_sint xr2, ggi_sint y2);
void	GGIEXP(triangle)(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2, ggi_sint x3, ggi_sint y3);
void	(*GGIEXP(drawPoly)[2])(ggi_visual_t vis, ggi2d_coord coords[], ggi_uint count);
void	GGIEXP(fillPoly)(ggi_visual_t vis, ggi2d_coord coords[], ggi_uint count);
void	GGIEXP(fillPolys)(ggi_visual_t vis, ggi2d_coord coords[], ggi_uint counts[], ggi_uint count);
void	GGIEXP(blit)(
		ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
		ggi2d_image src, ggi_sint sx, ggi_sint sy, 
		ggi_sint width, ggi_sint height);	
void	GGIEXP(blitOp)(
		ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
		ggi2d_image src1, ggi_sint s1x, ggi_sint s1y,
		ggi2d_image src2, ggi_sint s2x, ggi_sint s2y, 
		ggi_sint width, ggi_sint height, ggi2d_operator op);
void	GGIEXP(stretchBlit)(
		ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
		ggi_sint dwidth, ggi_sint dheight, 
		ggi2d_image src, ggi_sint sx, ggi_sint sy, 
		ggi_sint swidth, ggi_sint sheight);
void	GGIEXP(stretchBlitOp)(
		ggi_visual_t vis, ggi_sint dx, ggi_sint dy, 
		ggi_sint dwidth, ggi_sint dheight, 
		ggi2d_image src1, ggi_sint s1x, ggi_sint s1y,
		ggi2d_image src2, ggi_sint s2x, ggi_sint s2y, 
		ggi_sint swidth, ggi_sint sheight, ggi2d_operator op);
		
/*----------------------------------------------------------------------*/

#endif	/*_LIB_H_*/
