/* 
 *  horizontal line drawing
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"
#include "util.h"

/*----------------------------------------------------------------------*/

static void	hLine(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y)
{
	ggi_sint	x;
	void	(*drawPixel)(ggi_visual_t, ggi_sint, ggi_sint) 
    		= GGI2D_FUNC(vis)->drawPixel;
    
	CLIPHLINE(vis, x1, x2, y, x);
	for (x = x1; x <= x2; x++) drawPixel(vis, x, y);
}

static void	hLine_st(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y)
{
}

void	(*GGIEXP(hLine)[2])(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y) =
{
	hLine,
	hLine_st
};

/*----------------------------------------------------------------------*/

void	GGIEXP(scanline)(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y)
{
	ggi_sint	x;
	void	(*putPixel)(ggi_visual_t, ggi_sint, ggi_sint, ggi_pixel) 
    		= GGI2D_FUNC(vis)->putPixel;
	void	(*fillPixel)(ggi_visual_t, ggi_sint, ggi_sint) 
    		= GGI2D_FUNC(vis)->fillPixel;
    
	CLIPHLINE(vis, x1, x2, y, x);
	if (!GGI2D_GC_TEXTURED(vis))
		for (x = x1; x <= x2; x++) 
			putPixel(vis, x, y, GGI2D_GC_FILLCOL(vis));
	else
		for (x = x1; x <= x2; x++) 
			fillPixel(vis, x, y);
}

void	GGIEXP(scanlines)(ggi_visual_t vis, ggi2d_scanline scanlines[], ggi_uint count)
{
	int	i;
	void 	(*scanline)(ggi_visual_t, int, int, int) 
		= GGI2D_FUNC(vis)->scanline;
    
	for (i = 0; i < count; i++)
		scanline(vis, scanlines[i].x1, scanlines[i].x2, scanlines[i].y);
}

/*----------------------------------------------------------------------*/
