/* 
 *  ellipse drawing
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"
#include "util.h"

/*----------------------------------------------------------------------*/

static void	drawEllipse(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint a, ggi_uint b)
{
	void 	(*drawPixel)(ggi_visual_t, ggi_sint, ggi_sint)
		= GGI2D_FUNC(vis)->drawPixel;

#define PLOT(x, y)		drawPixel(vis, x, y)

#include "template/ellipse.h"
}

static void	drawEllipse_st(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint a, ggi_uint b)
{
}

void	GGIEXP(fillEllipse)(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint a, ggi_uint b)
{
	void 	(*scanline)(ggi_visual_t, ggi_sint, ggi_sint, ggi_sint) 
		= GGI2D_FUNC(vis)->scanline;

#define SCANLINE(x1, x2, y)	scanline(vis, x1, x2, y)
#define	FILL

#include "template/ellipse.h"
}

void	(*GGIEXP(drawEllipse)[2])(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_uint a, ggi_uint b) =
{
	drawEllipse,
	drawEllipse_st
};

/*----------------------------------------------------------------------*/
