/* 
 *  vertical line drawing
 *
 *  Copyright (C) 1998 by Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"
#include "util.h"

/*----------------------------------------------------------------------*/

void	GGIEXP(vLine_SET)(ggi_visual_t vis, ggi_sint x, ggi_sint y1, ggi_sint y2)
{
	ggi_sint	height;
	pixel	*ptr, color;
	
	CLIPVLINE(vis, x, y1, y2, height);
	ptr = LFBADDR(vis, x, y1);
	color = GGI2D_GC_DRAWCOL(vis);
	height = y2 - y1 + 1;
	while (height--) { *ptr = color; ptr += LIBGGI_FB_W_STRIDE(vis); }
}

/*----------------------------------------------------------------------*/
