/* 
 *  Library internal declarations
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _LIB_H_
#define _LIB_H_

#include "ggi2dlib.h"

#define TARGETNAME	"linear-8"

#define	pixel	uint8
#define	LFBADDR(vis,x,y) ((pixel*)((char*)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+x))
#define	LFBRADDR(vis,x,y) ((pixel*)((char*)LIBGGI_CURREAD(vis)+y*LIBGGI_FB_R_STRIDE(vis)+x))

void	(*GGIEXP(putPixel)[16])(ggi_visual_t vis, ggi_sint x, ggi_sint y, ggi_pixel col);
void	(*GGIEXP(drawPixel)[16])(ggi_visual_t vis, ggi_sint x, ggi_sint y);
void	GGIEXP(fillPixel)(ggi_visual_t vis, ggi_sint x, ggi_sint y);

void	GGIEXP(drawHLine_NOOP)(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y);
void	GGIEXP(drawHLine_INVERT)(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y);
void	GGIEXP(hLine)(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y);
void	GGIEXP(scanline)(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y);

void	GGIEXP(vLine_SET)(ggi_visual_t vis, ggi_sint x, ggi_sint y1, ggi_sint y2);
void	GGIEXP(fillRect_SET)(ggi_visual_t vis, ggi_sint x1, ggi_sint y1, ggi_sint x2, ggi_sint y2);

#endif	/*_LIB_H_*/
