#ifndef _GGI_INTERNAL_GGI_DL_H
#define _GGI_INTERNAL_GGI_DL_H

#include <ggi/types.h>
#include <ggi/internal/gii-dl.h>
#include <ggi/internal/internal.h>
#include <ggi/internal/dltypes.h>
#include <ggi/internal/dlprotos.h>

#define CHECKXY(vis,xloc,yloc) \
	{ if ((xloc)< (LIBGGI_GC(vis)->cliptl.x) || \
	      (yloc)< (LIBGGI_GC(vis)->cliptl.y) || \
	      (xloc)>=(LIBGGI_GC(vis)->clipbr.x) || \
	      (yloc)>=(LIBGGI_GC(vis)->clipbr.y)) return 0; }

#define CHECKXYW(vis,xloc,yloc,w) \
	{ CHECKXY(vis,xloc,yloc); \
	  if (((xloc)+(w)) > (LIBGGI_GC(vis)->clipbr.x)) return 0; \
	  if ((w) <= 0) return 0; }

#define CHECKXYH(vis,xloc,yloc,h) \
	{ CHECKXY(vis,xloc,yloc); \
	  if (((yloc)+(h)) > (LIBGGI_GC(vis)->clipbr.y)) return 0; \
	  if ((h) <= 0) return 0; }

#define CHECKXYWH(vis,xloc,yloc,w,h) \
	{ CHECKXY(vis,xloc,yloc); \
	  if (((xloc)+(w)) > (LIBGGI_GC(vis)->clipbr.x)) return 0; \
	  if ((w) <= 0) return 0; \
	  if (((yloc)+(h)) > (LIBGGI_GC(vis)->clipbr.y)) return 0; \
	  if ((h) <= 0) return 0; }

#endif /* _GGI_INTERNAL_GGI_DL_H */
