/* $Id: init.c,v 1.9 1998/10/29 21:36:57 becka Exp $
***************************************************************************

   Misc extension initialization.

   Copyright (C) 1997 Uwe Maurer - uwe_maurer@t-online.de
   Copyright (C) 1998 Andreas Beck - becka@ggi-project.org
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include "misc_int.h"

/*
 * The API of Extension #1 looks a bit like this :
 */

/* Extension ID. Defaulting to -1 should make segfault on abuse more likely ... */
ggi_extid ggiMiscID=-1;

static int changed(ggi_visual_t vis,int whatchanged)
{
	DPRINT("changed() called for misc extension - vis=%p, %i \n",
		vis,whatchanged);

	switch(whatchanged) {
		case GGI_CHG_APILIST:
			{	int temp;
				char api[256],args[256];
				void *err;
				DPRINT("changed() APILIST \n");
				for(temp=0;0==ggiGetAPI(vis,temp,api,args);temp++) {
					strcat(api,"-misc");
                	                DPRINT("Trying #%d: %s(%s)\n",temp,api,args);
					err=_ggiAddDL(vis, api, args, NULL, GGI_DLTYPE_EXTENSION);
                	                DPRINT("Loaded #%d: %s(%s) : %p\n",temp,api,args,err);
				}
			}
			break;
	}
                                
	return 0;
}

static int _ggi_error(void) { return -1; }

int ggiMiscInit(void)
{
	ggiMiscID=ggiExtensionRegister("GGIMisc",sizeof(miscext),changed);
	DPRINT("Initialized Misc extension. ID: %i\n",ggiMiscID);

	return ggiMiscID >= 0 ? 0 : -1;
}

int ggiMiscExit(void)
{
	int rc;
	rc=ggiExtensionUnregister(ggiMiscID);
	DPRINT("DeInitailized Misc extension. rc=%i\n", rc);

	return rc;
}

int ggiMiscAttach(ggi_visual_t vis)
{
	int rc;
	rc=ggiExtensionAttach(vis,ggiMiscID);
	DPRINT("Attached Misc extension to %p. rc=%i\n", vis, rc);

	if (rc==0) {	/* We are actually creating the primary instance. */
		memset(LIBGGI_MISCEXT(vis),0,sizeof(miscext));
		LIBGGI_MISCEXT(vis)->setsplitline
			=(int (*)(ggi_visual *vis,int y)) _ggi_error;
                LIBGGI_MISCEXT(vis)->getraypos=
		LIBGGI_MISCEXT(vis)->waitraypos
			=(int (*)(ggi_visual* vis,sint32 *x,sint32 *y))
			_ggi_error;
                        
		/* Now fake an "API change" so the right libs get loaded */
		changed(vis,GGI_CHG_APILIST);
	}

	return rc;
}

int ggiMiscDetach(ggi_visual_t vis)
{
	int rc;
	rc=ggiExtensionDetach(vis,ggiMiscID);
	DPRINT("Detached Misc extension from %p. rc=%i\n", vis, rc);

	return rc;
}

