/* $Id: vcsahook.h,v 1.2 1998/10/28 01:55:16 ajapted Exp $
***************************************************************************

   Display-VCSA: definitions

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _DISPLAY_VCSA_H
#define _DISPLAY_VCSA_H

#include <ggi/internal/ggi-dl.h>


/* Visual-private data */

typedef struct vcsa_hook
{	
	int width;
	int height;

} VcsaHook;

#define VCSA_HOOK(vis) ((VcsaHook *) LIBGGI_PRIVATE(vis))


/** 
 ** LibGGI internal stuff
 **/

ggifunc_getmode		GGI_vcsa_getmode;
ggifunc_setmode		GGI_vcsa_setmode;
ggifunc_checkmode	GGI_vcsa_checkmode;
ggifunc_resetmode	GGI_vcsa_resetmode;
ggifunc_getapi		GGI_vcsa_getapi;
ggifunc_flush		GGI_vcsa_flush;
ggifunc_setflags	GGI_vcsa_setflags;

ggifunc_putpixel_nc	GGI_vcsa_putpixel_nc;
ggifunc_getpixel	GGI_vcsa_getpixel;
ggifunc_putc		GGI_vcsa_putc;
ggifunc_getcharsize	GGI_vcsa_getcharsize;

ggifunc_mapcolor	GGI_vcsa_mapcolor;
ggifunc_unmappixel	GGI_vcsa_unmappixel;


#endif  /* _DISPLAY_VCSA_H */
