/* $Id: TIvisual.h,v 1.8 1998/09/26 18:42:17 marcus Exp $
 *
 * Copyright 1998 MenTaLboY - mentalboy@geocities.com
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>

#include <ggi/internal/ggi-dl.h>

#ifdef __GNUC__
# undef alloca
# define alloca __builtin_alloca
#else
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
#pragma alloca
#  else
#   ifndef alloca /* predefined by HP cc +Olibcalls */
char *alloca ();
#   endif
#  endif
# endif
#endif

#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#ifdef HAVE_NCURSES_NCURSES_H
#include <ncurses/ncurses.h>
#endif
#endif

struct TIhooks {
	SCREEN *scr;
	FILE *f_in, *f_out;
	int f_private;
	struct { int x, y; } origin;
	int splitline;
	int virgin;
	chtype color16_table[256];
	chtype charmap[256];
};

#ifdef USE_THREADS
	#warning ncurses MUST have been compiled with -D_REENTRANT
	#include <pthread.h>
	extern pthread_mutex_t _tivisual_ncurses_mutex;
	#define lock_ncurses() pthread_mutex_lock(&_tivisual_ncurses_mutex)
	#define unlock_ncurses() pthread_mutex_unlock(&_tivisual_ncurses_mutex)
#else
	#define lock_ncurses()
	#define unlock_ncurses()
#endif

/* Prototypes
 */

ggifunc_flush		GGI_terminfo_flush;
ggifunc_getmode		GGI_terminfo_getmode;
ggifunc_setmode		GGI_terminfo_setmode;
ggifunc_checkmode	GGI_terminfo_checkmode;
ggifunc_getapi		GGI_terminfo_getapi;
ggifunc_setflags	GGI_terminfo_setflags;
ggifunc_eventpoll	GGI_terminfo_eventpoll;
ggifunc_eventread	GGI_terminfo_eventread;
ggifunc_seteventmask	GGIseteventmask;

extern int paint_ncurses_window(ggi_visual *, WINDOW *, int, int);
