/* $Id: visual.c,v 1.9 1998/10/18 15:53:04 becka Exp $
***************************************************************************

   Tltarget.

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/mman.h>

#include <ggi/internal/ggi-dl.h>

#include "libtele.h"
#include "telehook.h"


/* 
 * We are guaranteed to have been smacked already...
 */

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	TeleHook *th;

	int err;

	
	LIBGGI_FD(vis)=-1;

	LIBGGI_PRIVATE(vis) = th = _ggi_malloc(sizeof(TeleHook));

	th->client = _ggi_malloc(sizeof(TeleClient));
	th->connected = 0;
	th->mode_up = 0;
	th->wait_event = NULL;

	vis->gc = _ggi_malloc(sizeof(ggi_gc));

	vis->opdisplay->getmode=GGI_tele_getmode;
	vis->opdisplay->setmode=GGI_tele_setmode;
	vis->opdisplay->checkmode=GGI_tele_checkmode;
	vis->opdisplay->flush=GGI_tele_flush;

	vis->opdisplay->eventpoll=GGI_tele_eventpoll;
	vis->opdisplay->eventread=GGI_tele_eventread;
	vis->opdisplay->seteventmask=GGIseteventmask;

	fprintf(stderr, "Connecting to the TeleServer...\n");

	if (args) {
		err = tclient_open(th->client, args);
	} else {
		err = tclient_open(th->client, "inet:127.0.0.1:27780");
	}

	if (err < 0) {
		free(vis->gc);
		free(th->client);
		free(th);
		return -1;
	}
	
	th->connected = 1;

	fprintf(stderr, "... connection established.\n");

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	TeleHook *th = TELE_PRIV(vis);

	if (th->mode_up) {
		GGI_tele_resetmode(vis);
	}
	
	if (th->connected) {
		tclient_close(th->client);
		th->connected = 0;
	}

	free(vis->gc);
	free(th->client);
	free(th);

	return 0;
}

int GGI_tele_flush(ggi_visual *vis, int tryflag)
{
	TeleHook *th = TELE_PRIV(vis);
	TeleEvent ev;

	int err;

	
	if (! th->mode_up) {
		return -1;
	}

	tclient_new_event(th->client, &ev, TELE_CMD_FLUSH, 0, 0);

	err = tclient_write(th->client, &ev);

	if (err == TELE_ERROR_SHUTDOWN) {
		TELE_HANDLE_SHUTDOWN;
	}

	return err;
}

#include <ggi/internal/ggidlinit.h>
