/* $Id: draw.c,v 1.4 1998/09/25 21:32:56 becka Exp $
***************************************************************************

   TELE target.

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#include "libtele.h"
#include "telehook.h"


int GGI_tele_drawpixel_nc(ggi_visual *vis, int x, int y)
{
	return GGI_tele_putpixel_nc(vis, x, y, LIBGGI_GC_FGCOLOR(vis));
}

int GGI_tele_drawpixel(ggi_visual *vis, int x, int y)
{
	CHECKXY(vis, x, y);

	return GGI_tele_putpixel_nc(vis, x, y, LIBGGI_GC_FGCOLOR(vis));
}

/* FIXME !!! this is confused */

int GGI_tele_drawbox_nc(ggi_visual *vis, int x, int y, int w, int h)
{
	TeleHook *th = TELE_PRIV(vis);
	TeleCmdDrawBoxData *p;
	TeleEvent ev;

	int err;

	p = tclient_new_event(th->client, &ev, TELE_CMD_DRAWBOX,
			      sizeof(TeleCmdDrawBoxData), 0);
	p->x = x;
	p->y = y;
	p->width  = w;
	p->height = h;
	p->pixel  = LIBGGI_GC_FGCOLOR(vis);
	
	err = tclient_write(th->client, &ev);

	if (err == TELE_ERROR_SHUTDOWN) {
		TELE_HANDLE_SHUTDOWN;
	}

	return err;
}

int GGI_tele_drawbox(ggi_visual *vis, int x, int y, int w, int h)
{
	TeleHook *th = TELE_PRIV(vis);
	TeleCmdDrawBoxData *p;
	TeleEvent ev;

	int err;


	/* clip */

	if ((x+w) > LIBGGI_GC(vis)->clipbr.x) {
		w = LIBGGI_GC(vis)->clipbr.x - x;
	}
	if ((y+h) > LIBGGI_GC(vis)->clipbr.y) {
		h = LIBGGI_GC(vis)->clipbr.y - y;
	}
	if (x < LIBGGI_GC(vis)->cliptl.x) {
		w -= (LIBGGI_GC(vis)->cliptl.x - x);
		x = LIBGGI_GC(vis)->cliptl.x;
	}
	if (y < LIBGGI_GC(vis)->cliptl.y) {
		h -= (LIBGGI_GC(vis)->cliptl.y - y);
		y = LIBGGI_GC(vis)->cliptl.y;
	}
	if ((w <= 0) || (h <= 0)) {
		return -1;
	}

	p = tclient_new_event(th->client, &ev, TELE_CMD_DRAWBOX,
			      sizeof(TeleCmdDrawBoxData), 0);
	p->x = x;
	p->y = y;
	p->width  = w;
	p->height = h;
	p->pixel  = LIBGGI_GC_FGCOLOR(vis);
	
	err = tclient_write(th->client, &ev);

	if (err == TELE_ERROR_SHUTDOWN) {
		TELE_HANDLE_SHUTDOWN;
	}

	return err;
}

int GGI_tele_copybox(ggi_visual *vis, int x, int y, int w, int h, int nx, int ny)
{
	TeleHook *th = TELE_PRIV(vis);
	TeleCmdCopyBoxData *p;
	TeleEvent ev;

	int err;


	/* clip */

	if ((x < 0) || (y < 0) ||
	    ((x+w) > LIBGGI_MODE(vis)->virt.x) ||
	    ((y+h) > LIBGGI_MODE(vis)->virt.y)) {

	    	/* source box is invalid */
		return -2;
	}

	if ((nx+w) > LIBGGI_GC(vis)->clipbr.x) {
		w = LIBGGI_GC(vis)->clipbr.x - nx;
	}
	if ((ny+h) > LIBGGI_GC(vis)->clipbr.y) {
		h = LIBGGI_GC(vis)->clipbr.y - ny;
	}
	if (nx < LIBGGI_GC(vis)->cliptl.x) {
		w -= (LIBGGI_GC(vis)->cliptl.x - nx);
		x += (LIBGGI_GC(vis)->cliptl.x - nx);
		nx = LIBGGI_GC(vis)->cliptl.x;
	}
	if (ny < LIBGGI_GC(vis)->cliptl.y) {
		h -= (LIBGGI_GC(vis)->cliptl.y - ny);
		y += (LIBGGI_GC(vis)->cliptl.y - ny);
		ny = LIBGGI_GC(vis)->cliptl.y;
	}
	if ((w <= 0) || (h <= 0)) {
		return -1;
	}

	p = tclient_new_event(th->client, &ev, TELE_CMD_COPYBOX,
			      sizeof(TeleCmdCopyBoxData), 0);
	p->sx = x;
	p->sy = y;
	p->width  = w;
	p->height = h;
	p->dx = nx;
	p->dy = ny;
	
	err = tclient_write(th->client, &ev);

	if (err == TELE_ERROR_SHUTDOWN) {
		TELE_HANDLE_SHUTDOWN;
	}

	return err;
}


/* ---------------------------------------------------------------------- */


int GGI_tele_drawhline_nc(ggi_visual *vis, int x, int y, int w)
{
	return GGI_tele_drawbox_nc(vis, x, y, w, 1);
}

int GGI_tele_drawvline_nc(ggi_visual *vis, int x, int y, int h)
{
	return GGI_tele_drawbox_nc(vis, x, y, 1, h);
}

int GGI_tele_drawhline(ggi_visual *vis, int x, int y, int w)
{
	return GGI_tele_drawbox(vis, x, y, w, 1);
}

int GGI_tele_drawvline(ggi_visual *vis, int x, int y, int h)
{
	return GGI_tele_drawbox(vis, x, y, 1, h);
}
