/* $Id: draw.c,v 1.6 1998/10/04 07:29:19 ajapted Exp $
***************************************************************************

   Display-palemu: draw

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#include "palemu.h"


/* The following operations update the 'dirty region', which is used to
 * limit the area blitted to the parent at ggiFlush() time.
 */

int GGI_palemu_drawpixel_nc(ggi_visual *vis, int x, int y)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, 1);
	
	return ph->mem_opdraw->drawpixel_nc(vis, x, y);
}

int GGI_palemu_drawpixel(ggi_visual *vis, int x, int y)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, 1);
	
	return ph->mem_opdraw->drawpixel(vis, x, y);
}

int GGI_palemu_putpixel_nc(ggi_visual *vis, int x, int y, ggi_pixel col)
{ 
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, 1);
	
	return ph->mem_opdraw->putpixel_nc(vis, x, y, col);
}

int GGI_palemu_putpixel(ggi_visual *vis, int x, int y, ggi_pixel col)
{ 
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, 1);
	
	return ph->mem_opdraw->putpixel(vis, x, y, col);
}

int GGI_palemu_drawline(ggi_visual *vis, int x1, int y1, int x2, int y2)
{ 
	PalemuHook *ph = PALEMU_PRIV(vis);

	int sx = MIN(x1, x2);
	int sy = MIN(y1, y2);

	int ex = MAX(x1, x2);
	int ey = MAX(y1, y2);

	UPDATE_MOD(vis, sx, sy, ex-sx, ey-sy);

	return ph->mem_opdraw->drawline(vis, x1, y1, x2, y2);
}

int GGI_palemu_drawhline_nc(ggi_visual *vis, int x, int y, int w)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, w, 1);

	return ph->mem_opdraw->drawhline_nc(vis, x, y, w);
}

int GGI_palemu_drawhline(ggi_visual *vis, int x, int y, int w)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, w, 1);

	return ph->mem_opdraw->drawhline(vis, x, y, w);
}

int GGI_palemu_puthline(ggi_visual *vis, int x, int y, int w, void *buffer)
{ 
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, w, 1);

	return ph->mem_opdraw->puthline(vis, x, y, w, buffer);
}

int GGI_palemu_drawvline_nc(ggi_visual *vis, int x, int y, int h)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, h);
	
	return ph->mem_opdraw->drawvline_nc(vis, x, y, h);
}

int GGI_palemu_drawvline(ggi_visual *vis, int x, int y, int h)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, h);
	
	return ph->mem_opdraw->drawvline(vis, x, y, h);
}

int GGI_palemu_putvline(ggi_visual *vis, int x, int y, int h, void *buffer)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, 1, h);
	
	return ph->mem_opdraw->putvline(vis, x, y, h, buffer);
}

int GGI_palemu_putbox(ggi_visual *vis, int x, int y, int w, int h, void *buffer)
{ 
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, w, h);

	return ph->mem_opdraw->putbox(vis, x, y, w, h, buffer);
}

int GGI_palemu_drawbox(ggi_visual *vis, int x, int y, int w, int h)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, x, y, w, h);

	return ph->mem_opdraw->drawbox(vis, x, y, w, h);
}

int GGI_palemu_fillscreen(ggi_visual *vis)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, 0, 0, LIBGGI_VIRTX(vis), LIBGGI_VIRTY(vis));

	return ph->mem_opdraw->fillscreen(vis);
}


/* ---------------------------------------------------------------------- */


int GGI_palemu_copybox(ggi_visual *vis, int x, int y, int w, int h, int nx, int ny)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, nx, ny, w, h);

	return ph->mem_opdraw->copybox(vis, x, y, w, h, nx, ny);
}

int GGI_palemu_crossblit(ggi_visual *src, int sx, int sy, int w, int h,
			 ggi_visual *vis, int dx, int dy)
{
	PalemuHook *ph = PALEMU_PRIV(vis);
	
	UPDATE_MOD(vis, dx, dy, w, h);

	return ph->mem_opdraw->crossblit(src, sx, sy, w, h, vis, dx, dy);
}


/* ---------------------------------------------------------------------- */


/* The following functions are just pass-throughs to the parent visual.
 */

int GGI_palemu_setorigin(ggi_visual *vis, int x, int y)
{
	PalemuHook *ph = PALEMU_PRIV(vis);

	int err;
	
	if ((err = ggiSetOrigin(ph->parent, x, y)) != 0) {
		return err;
	}

	vis->origin_x = x;
	vis->origin_y = y;
	
	return 0;
}
