/* $Id: mode.c,v 1.13 1998/10/13 07:54:21 marcus Exp $
***************************************************************************

   Display-multi: mode management

   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]
   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <ggi/internal/ggi-dl.h>

#include "multi_defs.h"


int GGI_multi_setmode(ggi_visual *vis, ggi_mode *tm)
{ 
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiSetMode(cur->vis, tm) != 0) err--;
	}

	if (err) return err;

	memcpy(LIBGGI_MODE(vis), tm, sizeof(ggi_mode));

	return 0;
}

int GGI_multi_checkmode(ggi_visual *vis, ggi_mode *tm)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiCheckMode(mm->vis_list->vis, tm);
}

int GGI_multi_getmode(ggi_visual *vis, ggi_mode *tm)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);

	return ggiGetMode(mm->vis_list->vis, tm);
}

int GGI_multi_setflags(ggi_visual *vis,ggi_flags flags)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (ggiSetFlags(cur->vis, flags) != 0) err--;
	}

	LIBGGI_FLAGS(vis) = flags;

	return err;
}
                

int GGI_multi_flush(ggi_visual *vis, int tryflag)
{
	MultiHook *mm = LIBGGI_PRIVATE(vis);
	MultiVis *cur;

	int err=0;

	for (cur=mm->vis_list; cur != NULL; cur=cur->next) {
		if (_ggiInternFlush(cur->vis, tryflag) != 0) err--;
	}

	return err;
}
