/* $Id: visual.c,v 1.17 1998/10/24 04:03:44 marcus Exp $
***************************************************************************

   GLIDE target - Initialization

   Copyright (C) 1997-1998	Jon Taylor	[taylorj@ecs.csus.edu]
   Copyright (C) 1998		Marcus Sundberg	[marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include "glidevisual.h"

static gg_option glide_options[1] = 
{
	{ "mouse",  "" }
};

int GGIdlinit(ggi_visual *vis, const char *args,void *argptr)
{
	struct glide_hooks *glidehook;
	
	DPRINT("GLIDE-lib starting\n");

	LIBGGI_PRIVATE(vis) = glidehook
		= _ggi_malloc(sizeof(struct glide_hooks));

	glidehook->setmodesuccess = 0;

	MOUSE_FD(vis) = LIBGGI_FD(vis) = LIBGGI_SELECT_FD(vis) = -1;

	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	/* handle args */

	if (getenv("GGI_GLIDE_OPTIONS") != 0) {
		if (ggParseOptions(getenv("GGI_GLIDE_OPTIONS"),
			glide_options, 1) == NULL) {
			fprintf(stderr, "display-glide: error in "
				"$GGI_GLIDE_OPTIONS.\n");
			free(glidehook);
			return GGI_DL_ERROR;
		}
	}
	
	if (args) {
		if (ggParseOptions((char *)args, glide_options, 1)==NULL) {
			
			fprintf(stderr, "display-glide: error in "
				"arguments.\n");
			free(glidehook);
			return GGI_DL_ERROR;
		}
	}
	
	if (*glide_options[0].result) {
		glidehook->mousetype = glide_options[0].result;
	} else {
		glidehook->mousetype = glide_options[1].result;
	}

	fprintf(stderr, "display-glide: mouse='%s'\n", glidehook->mousetype);

	/* Prevent 3DFX splash-screen from being displayed */
	if (getenv("FX_GLIDE_NO_SPLASH") == NULL)
		setenv("FX_GLIDE_NO_SPLASH", "1", 0);

	grGlideInit();
	grSstSelect(0);
	
	/* Has mode management */
	vis->opdisplay->flush = GGI_glide_flush;
	vis->opdisplay->getmode = GGI_glide_getmode;
	vis->opdisplay->setmode = GGI_glide_setmode;
	vis->opdisplay->checkmode = GGI_glide_checkmode;
	vis->opdisplay->getapi = GGI_glide_getapi;
	vis->opdisplay->flush = GGI_glide_flush;	

	/* Has Event management */
	vis->opdisplay->eventpoll = GGI_glide_eventpoll;
	vis->opdisplay->eventread = GGI_glide_eventread;
	vis->opdisplay->seteventmask = GGIseteventmask;

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	struct glide_hooks *glidehook = LIBGGI_PRIVATE(vis);

	LIBGGI_ASSERT(glidehook != NULL,
		      "glide: Visual NULL in GGIdlcleanup!");

	if (glidehook->setmodesuccess) {
		mouse_exit(vis);
		keyboard_exit(vis);
		vtswitch_close(vis);
	}

	free(glidehook);

	free(LIBGGI_GC(vis));
	
	grGlideShutdown();

	return 0;
}

#include <ggi/internal/ggidlinit.h>
