/* $Id: pixel.c,v 1.4 1998/09/24 01:24:40 marcus Exp $
***************************************************************************

   LibGGI GLIDE target - Pixel functions

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "glidevisual.h"
#include "../../default/color/color.h"


int
GGI_glide_drawpixel(ggi_visual *vis,int x,int y)
{
	GLIDE_PRIV(vis)->fgvertex.x = x;
	GLIDE_PRIV(vis)->fgvertex.y = y;

	grDrawPoint(&GLIDE_PRIV(vis)->fgvertex);
	
	return 0;
}

#define DOSHIFT(val, shift)  \
	(((shift) >= 0) ? (val) << (shift) : (val) >> -(shift))
int
GGI_glide_putpixel(ggi_visual *vis, int x, int y, ggi_pixel pix)
{
	color_hook *ck = (color_hook *) vis->colorpriv;
	GrVertex vert;

	vert.x = x;
	vert.y = y;
	vert.r = DOSHIFT(pix & LIBGGI_PIXFMT(vis)->red_mask,
			 8 - ck->red_total);
	vert.g = DOSHIFT(pix & LIBGGI_PIXFMT(vis)->green_mask,
			 8 - ck->green_total);
	vert.b = DOSHIFT(pix & LIBGGI_PIXFMT(vis)->blue_mask,
			 8 - ck->blue_total);
	vert.a = 255;

	grDrawPoint(&vert);

	return 0;
}

int
GGI_glide_getpixel(ggi_visual *vis,int x,int y,ggi_uint *pixel)
{
	/* This is needed to handle big/little endianess */
	switch (GLIDE_PRIV(vis)->bytes_per_pixel) {
	case 4: {
		uint32 pix;
		grLfbReadRegion(GLIDE_PRIV(vis)->readbuf, x-1, y-1,
				1, 1, 1, &pix);
		*pixel = pix;
		break;
	}
	case 3: {
		/* FIXME? */
		uint32 pix;
		grLfbReadRegion(GLIDE_PRIV(vis)->readbuf, x-1, y-1,
				1, 1, 1, &pix);
		*pixel = pix;
		break;
	}
	case 2: {
		uint16 pix;
		grLfbReadRegion(GLIDE_PRIV(vis)->readbuf, x-1, y-1,
				1, 1, 1, &pix);
		*pixel = pix;
		break;
	}
	}
	return 0;
}
