/* $Id: ppm.c,v 1.1 1998/10/13 11:13:58 ajapted Exp $
***************************************************************************

   Display-file: ppm writer

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#include <ggi/internal/ggi-dl.h>

#include "filehook.h"


#define PPM_INFO_STRING  "# Generated by display-file target of LibGGI\n"


int _ggi_file_ppm_detect(char *filename)
{
	int len = strlen(filename);

	if (len < 5) {
		return 0;
	}

	return (strcmp(filename + (len-4), ".ppm") == 0);
}

void _ggi_file_ppm_write(ggi_visual *vis)
{
	char buf[200];

	int x, y;

	ggi_pixel last;
	ggi_color col;


	/* write header info */

	_ggi_file_write_string(vis, "P6\n");
	_ggi_file_write_string(vis, PPM_INFO_STRING);

	sprintf(buf, "%d %d\n255\n", LIBGGI_VIRTX(vis), LIBGGI_VIRTY(vis));
	_ggi_file_write_string(vis, buf);


	/* write out the pixels */

	ggiGetPixel(vis, 0, 0, &last);
	last = ~last;	/* must be different from first pixel */

	for (y=0; y < LIBGGI_VIRTY(vis); y++)
	for (x=0; x < LIBGGI_VIRTX(vis); x++) {

		ggi_pixel pix;

		ggiGetPixel(vis, x, y, &pix);

		if (pix != last) {
			ggiUnmapPixel(vis, pix, &col);
		}

		_ggi_file_write_byte(vis, col.r >> 8);
		_ggi_file_write_byte(vis, col.g >> 8);
		_ggi_file_write_byte(vis, col.b >> 8);

		last = pix;
	}

	_ggi_file_flush(vis);
}
