/* $Id: fileio.c,v 1.1 1998/10/13 11:13:58 ajapted Exp $
***************************************************************************

   Display-file: file primitives

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include <ggi/internal/ggi-dl.h>

#include "filehook.h"


int _ggi_file_create_file(ggi_visual *vis, char *filename)
{
	FileHook *ff = FILE_PRIV(vis);

	LIBGGI_FD(vis) = open(filename, O_CREAT | O_TRUNC | O_RDWR, 0600);

	if (LIBGGI_FD(vis) < 0) {
		perror("display-file: Unable to create file");
		return -1;
	}

	ff->buf_len = 0;

	return 0;
}

void _ggi_file_close_file(ggi_visual *vis)
{
	_ggi_file_flush(vis);

	close(LIBGGI_FD(vis));

	LIBGGI_FD(vis) = -1;
}

void _ggi_file_flush(ggi_visual *vis)
{
	FileHook *ff = FILE_PRIV(vis);

	if (ff->buf_len <= 0) {
		return;
	}

	if (write(LIBGGI_FD(vis), ff->buffer, ff->buf_len) < 0) {
		perror("display-file: write error");
	}

	ff->buf_len = 0;
}

void _ggi_file_write_byte(ggi_visual *vis, int val)
{
	FileHook *ff = FILE_PRIV(vis);
	
	if (ff->buf_len >= FILE_BUFFER_SIZE) {
		_ggi_file_flush(vis);
	}

	ff->buffer[ff->buf_len] = (uint8) val;
	ff->buf_len++;
}

void _ggi_file_write_word(ggi_visual *vis, int val)
{
	_ggi_file_write_byte(vis, val >> 8);
	_ggi_file_write_byte(vis, val & 0xff);
}

void _ggi_file_write_string(ggi_visual *vis, char *str)
{
	for (; *str; str++) {
		_ggi_file_write_byte(vis, (unsigned char) *str);
	}
}

void _ggi_file_write_zeros(ggi_visual *vis, int count)
{
	for (; count > 0; count--) {
		_ggi_file_write_byte(vis, 0);
	}
}
