/* $Id: fillscreen.c,v 1.6 1998/09/23 21:36:01 marcus Exp $
***************************************************************************

   Graphics library for GGI. Fillscreenfunctions for Xlib.

   Copyright (C) 1998 Marcus Sundberg [marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "Xvisual.h"

/*************************************/
/* fill (erase) the (virtual) screen */
/*************************************/

int GGI_Xlib_fillscreen(ggi_visual *vis)
{
	XSetWindowBackground(XLIB_PRIV(vis)->display,
						 XLIB_PRIV(vis)->window,
						 LIBGGI_GC(vis)->fg_color);
	if (LIBGGI_GC(vis)->cliptl.x > 0
		|| LIBGGI_GC(vis)->cliptl.y > 0
		|| LIBGGI_GC(vis)->clipbr.x < LIBGGI_MODE(vis)->virt.x
		|| LIBGGI_GC(vis)->clipbr.y < LIBGGI_MODE(vis)->virt.x) 
		XClearArea(XLIB_PRIV(vis)->display,
				   XLIB_PRIV(vis)->window,
				   LIBGGI_GC(vis)->cliptl.x,
				   LIBGGI_GC(vis)->cliptl.y,
				   LIBGGI_GC(vis)->clipbr.x-LIBGGI_GC(vis)->cliptl.x,
				   LIBGGI_GC(vis)->clipbr.y-LIBGGI_GC(vis)->cliptl.y,
				   False);
	else
		XClearWindow(XLIB_PRIV(vis)->display,
					 XLIB_PRIV(vis)->window);

	return 0;
}
