/*
 * vr.c - (c) 1998 Andreas Beck   andreas.beck@ggi-project.org
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 *
 */

#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <ggi/ggi.h>

#define MAXX 320
#define MAXY 400

#define WINSIZE 159
#define WINY    99

ggi_visual_t vis;
ggi_mode mode;
ggi_color pal[256];
ggi_pixel lookup[256];

unsigned char field[MAXY][MAXX];
unsigned char color[MAXY][MAXX];
unsigned char drawscreen[64000];

struct posdata
 { int x,y,z,range,vvz;
   double alpha,phi;} pdt;

struct pos {int x,y,z;} scanbase[2*WINSIZE];

double xh,yh;

void display(void)
{ int dx,dy,dz,dxy;
  register int delta,delta1,dd,dov;
  unsigned char *grphptr;
  int xl,yl,zl;
  int sx,sy,sz;
  int xp,mxh,vz;
/*  char hst[40];*/

  for(xp=0;xp<2*WINSIZE;xp++)
  {grphptr=(unsigned char *) drawscreen+(100+WINY)*320+xp;
   if (xp>0&&memcmp((void *)&scanbase[xp],(void *)&scanbase[xp-1],sizeof(scanbase[0]))==0)
      {dz=WINY+WINY+1;
       while(dz--) {*grphptr=*(grphptr-1);grphptr-=320;}
       continue;}
   xl=pdt.x;yl=pdt.y;zl=pdt.z;
   dx=scanbase[xp].x;
   dy=scanbase[xp].y;
   dz=scanbase[xp].z;vz=-WINY-dz;mxh=-WINY;
   delta=delta1=dd=0;
   sx=(dx>0) ? 1 : -1;
   sy=(dy>0) ? 1 : -1;
   sz=(dz>0) ? 1 : -1;
   dx=abs(dx);dy=abs(dy);dz=abs(dz);
   delta=dy-dx;if (abs(delta)>=2) delta>>=1;
   if ((dov=dxy=dx+dy)>dz) delta1--;

   while(dov--)
   {dd++;
    if (delta>=0) {yl+=sy;delta-=dx;}
    else          {xl+=sx;delta+=dy;}
    delta1+=dz;
    while(delta1>=0) {zl+=sz;delta1-=dxy;}
    if (xl<0) if (sx<0) break;else continue;
    if (yl<0) if (sy<0) break;else continue;
    if (xl>=MAXX) if (sx>0) break;else continue;
    if (yl>=MAXY) if (sy>0) break;else continue;
    if (zl>255)   if (sz>0) break;else continue;
    if (field[yl][xl]>zl)
    { dz=((zl=field[yl][xl])-pdt.z)*dxy/dd;
      /*sprintf(hst,"%d",dz);GrTextXY(0,10,hst,63,0);getch();*/
      if (dxy>dz) delta1=-1;else delta1=0;
      if (dz+vz>WINY) dz=WINY-vz;
      while (dz+vz>=mxh)
      { mxh++;*grphptr=color[yl][xl];grphptr-=320; }
      sz=(dz>0) ? 1 : -1;
      if (dz==WINY-vz) break;
      dz=abs(dz);
      }
   }
   while (mxh<=WINY) {mxh++;*grphptr=0;grphptr-=320;}
  }
  if (mode.graphtype==GT_8BIT && mode.virt.x==320) {
    ggiPutBox(vis,0,0,320,200,drawscreen);
  } else {
    /* Messy and slow */
    int offx=(mode.virt.x-320)/2;
    int offy=(mode.virt.y-200)/2;
    for(dy=0; dy<200; dy++)
      for(dx=0; dx<320; dx++)
        ggiPutPixel(vis,offx+dx,offy+dy, lookup[drawscreen[dy*320+dx]]);
  }
  ggiFlush(vis);
}

void calc_line(void)
{ int xx;
  double alph2;
  for(xx=0,alph2=pdt.alpha+WINSIZE*pdt.phi;xx<2*WINSIZE;xx++,alph2-=pdt.phi)
  { scanbase[xx].x=sin(alph2)*pdt.range;
    scanbase[xx].y=cos(alph2)*pdt.range;
    scanbase[xx].z=-WINY+pdt.vvz;}
}

int get_input(void) {

   int evmask;
   ggi_event ev;
   struct timeval t={0,0};
      
   evmask=emKeyPress|emKeyRepeat|emKeyRelease|emPointer;

   ggiEventPoll(vis,evmask,NULL);	/* Block for at least 1 Event */
   while (ggiEventPoll(vis,evmask,&t))
   {
	do {
		ggiEventRead(vis,&ev,evmask);
	} while(! ( (1 << ev.any.type) & evmask ) );

	switch(ev.any.type) { 
	case evKeyPress:
	case evKeyRepeat:
		if (ev.key.sym <= 0xff) {
		  	switch(ev.key.sym) {
			case '\033': /* esc */
			case 'q': case'Q':
		 	 	return 1;
			case ';':
			  	pdt.alpha-=M_PI/8.0;calc_line();
			  	break;
			case ':':
				pdt.alpha+=M_PI/8.0;calc_line();
			  	break;
			case 'x':pdt.x++;break;
			case 'X':pdt.x--;break;
			case 'y':pdt.y++;break;
			case 'Y':pdt.y--;break;
			case 's':pdt.x+=10;break;
			case 'S':pdt.x-=10;break;
			case 'a':pdt.y+=10;break;
			case 'A':pdt.y-=10;break;
			case 't':pdt.z+=10;break;
			case 'T':pdt.z-=10;break;
			case 'w':pdt.range++;calc_line();break;
			case 'W':pdt.range--;calc_line();break;
			case GIIUC_Return: /* enter */
				break;

			default: printf("latin sym=%4x button=%4x (%c)\n",ev.key.sym,ev.key.button,ev.key.sym);break;
		  	}
		  	break;
		} else {
			switch(ev.key.sym) {
			case GIIK_Up: /* CrSr up */
			case GIIK_P8: /* Keypad 8 */
				if ( pdt.x!=(int)xh || pdt.y!=(int)yh ) 
					{ xh=pdt.x; yh=pdt.y; }
				while( pdt.x==(int)xh && pdt.y==(int)yh )
					{ xh+=sin(pdt.alpha);yh+=cos(pdt.alpha); } 
				if ( (int)xh<0 || (int)xh>MAXX || 
				     (int)yh<0 || (int)yh>MAXY ||
				     field[(int)yh][(int)xh] < pdt.z ) 
					{ pdt.x=xh;pdt.y=yh; }
				break;
			case GIIK_Down: /* CrSr down */
			case GIIK_P2: /* Keypad 2 */
				if ( pdt.x!=(int)xh || pdt.y!=(int)yh ) 
					{ xh=pdt.x;yh=pdt.y; }
				while( pdt.x==(int)xh && pdt.y==(int)yh )
					{ xh-=sin(pdt.alpha);yh-=cos(pdt.alpha); }
				if ( (int)xh<0 || (int)xh>MAXX || 
				     (int)yh<0 || (int)yh>MAXY ||
				     field[(int)yh][(int)xh] < pdt.z ) 
					{ pdt.x=xh;pdt.y=yh; }
				break;
			case GIIK_Right: /* CrSr right */
			case GIIK_P6: /* CrSr right */
				pdt.alpha-=0.08;calc_line();
				break;
			case GIIK_Left: /* CrSr left */
			case GIIK_P4: /* CrSr left */
				pdt.alpha+=0.08;calc_line();
				break;
	
			case GIIK_P7:
				pdt.vvz+=10;calc_line();break;
			case GIIK_P9:
				pdt.z++;break;
			case GIIK_P3:
				pdt.z--;break;
			case GIIK_P1:
				pdt.vvz-=10;calc_line();break;
			case GIIK_PPlus:
				pdt.phi*=1.1;calc_line();break;
			case GIIK_PMinus:
				pdt.phi/=1.1;calc_line();break;

			case GIIK_Shift:
				break;

			default: printf("sym=%4x button=%4x\n",ev.key.sym,ev.key.button);break;
			}
		}
		break;
	   case evPtrButtonPress:
		if (ev.pbutton.button&2) break;
		if (ev.pbutton.button&1) break;
	    	break;
	   case evPtrButtonRelease:
		if (ev.pbutton.button&2) break;
		if (ev.pbutton.button&1) break;
	    	break;
	   case evPtrAbsolute:
	    	/*ev.pmove*/
	    	break;
	}
	/* Now for "only now" effects.
	 */
	switch(ev.any.type) { 
	    case evPtrRelative:
	    	break;
	}
   }
	return 0;
}

int main(int argc,char *argv[])
{ char file[80];
  int xx,yy;
  struct pin { char r,g,b; };
  struct pin palin[256];
  
  if (argc!=2) {

	fprintf(stderr,"Usage : vr [scenery], where [scenery] is the basename i.e. land or burg\n");
	return 1;
  }

  if (ggiInit() != 0) {
	  fprintf(stderr, "%s: unable to initialize libggi, exiting.\n",
		  argv[0]);
	  exit(1);
  }
  if ((vis=ggiOpen(NULL)) == NULL) {
	  fprintf(stderr, "%s: unable to open default visual, exiting.\n",
		  argv[0]);
	  exit(1);
  }
  
  if ( ggiSetGraphMode(vis,GGI_AUTO,GGI_AUTO,GGI_AUTO,GGI_AUTO,GT_AUTO) )
    ggiPanic(vis,"Defaultmode not available. Patch me !\n");

  ggiSetFlags(vis, GGIFLAG_ASYNC);
  ggiGetMode(vis, &mode);
  if(mode.virt.x < 320 || mode.virt.y < 200)
    ggiPanic(vis,"Defaultmode too small!\n");
  xh=yh=0.0;

  strcpy(file,argv[1]);strcat(file,".col");
  if ((xx=open(file,O_RDONLY))==-1) puts("Color-Data not found");
  else
  { read(xx,&palin,sizeof(palin));
    for(yy=0;yy<256;yy++) 
    { pal[yy].r=palin[yy].r<<10;
      pal[yy].g=palin[yy].g<<10;
      pal[yy].b=palin[yy].b<<10; }

    if(mode.graphtype==GT_8BIT)
      ggiSetPalette(vis,0,256,pal);

    for(yy=0;yy<256;yy++)
    { lookup[yy]=ggiMapColor(vis,pal+yy); }

    read(xx,&color,64000);close(xx);
  }

  strcpy(file,argv[1]);strcat(file,".hgt");
  if ((xx=open(file,O_RDONLY))==-1) puts("Height-Data not found");
  else
  { read(xx,&palin,sizeof(palin));
    read(xx,&field,64000);close(xx);}

  pdt.x=MAXX/2;pdt.y=0;pdt.z=40;pdt.vvz=0;
  pdt.range=128;pdt.phi=M_PI/2/(5*2*WINSIZE);pdt.alpha=0.0;

  strcpy(file,argv[1]);strcat(file,".pos");
  if ((xx=open(file,O_RDONLY))!=-1)
  { read(xx,&pdt,sizeof(pdt));close(xx); }
  
  for(xx=0;xx<MAXX;xx++)
   for(yy=0;yy<MAXY;yy++)
    field[yy][xx]/=3;

  calc_line();

  do { display(); } while(get_input()==0);

  if ((xx=open(file,O_WRONLY))!=-1)
  { write(xx,&pdt,sizeof(pdt));close(xx); }

  ggiClose(vis);
  ggiExit();
  return EXIT_SUCCESS;
}
