/* $Id: hline.c,v 1.9 1998/09/26 03:20:44 marcus Exp $
***************************************************************************

   Graphics library for GGI. Horizontal lines.

   Copyright (C) 1995 Andreas Beck  [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include "lin4lib.h"

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGI_lin4_drawhline(ggi_visual *vis,int x,int y,int w)
{
	uint8 *fb;
	uint8 fg;
	
	CHECKXYW(vis,x,y,w);

	fb = (uint8 *) LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+(x/2);
	fg = (uint8) LIBGGI_GC_FGCOLOR(vis) & 0x0F;
	
	/* x is odd.  Read-modify-write left pixel. */
	if (x & 0x01) {
		*(fb++) = (*fb & 0xF0) | fg;
		w--;
	}
	
	memset(fb, fg, w>>1);

	/* Dangling right pixel. */
	if (w & 0x01) {
		*(fb+(w>>1)) = ( *(fb+(w>>1)) & 0x0F) | (fg << 4);
	}
		
	return 0;
}

int GGI_lin4_drawhline_nc(ggi_visual *vis,int x,int y,int w)
{
	uint8 *fb;
	uint8 fg;

	fb = (uint8 *) LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+(x/2);
	fg = (uint8) LIBGGI_GC_FGCOLOR(vis) & 0x0F;
	
	/* x is odd.  Read-modify-write left pixel. */
	if (x & 0x01) {
		*(fb++) = (*fb & 0xF0) | fg;
		w--;
	}
	
	memset(fb, fg, w>>1);

	/* Dangling right pixel. */
	if (w & 0x01) {
		*(fb+(w>>1)) = ( *(fb+(w>>1)) & 0x0F) | (fg << 4);
	}
		
	return 0;
}

int GGI_lin4_puthline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	uint8 *fb;
	uint16 color;
	uint8 *buf = (uint8 *)buffer;

	CHECKXYW(vis,x,y,w);
	
	fb=(uint8 *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+(x/2);
	
	/* Might as well take the memcpy speed up (multiple byte copy). */
	if (!(x & 0x01)) {
		memcpy(fb,buf,w>>1);
		if (w & 0x01)
			*(fb+(w>>1)) = ( *(fb+(w>>1)) & 0x0F) | (*((uint8 *)buf+(w>>1)) << 4);
		return 0;
	}
	
	/* x is odd. */
	/* Color is a 12-bit quantity.  Upper 8 bits hold the memory to copy.
	 * Lower 4 bits hold the lower 4 bits of the buffer byte read; we'll
	 * need it next loop. */
	/* Could be optimized for multiple-byte copy. */

	color = *fb >> 4;
	
	while (w-=2 > 0)
	{
		color <<= 8;
		color |= *(buf++);
		*(fb++) = color >> 4;
	}
	
	if (!w) {
		*fb = (color << 4) | (*fb & 0x0F);
	}
	
	return 0;
}


int GGI_lin4_gethline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	uint8 *fb;
	uint16 color;
	uint8 *buf = (uint8 *)buffer;

	fb=(uint8 *)LIBGGI_CURREAD(vis)+y*LIBGGI_FB_R_STRIDE(vis)+(x/2);
	
	/* If width is odd, the last 4 bits of the buffer's last
	 * byte will hold an extraneous pixel.  No big deal. */
	
	if (!(x & 0x01)) {
		memcpy(buf, fb, (w>>1) + (w & 0x01));
		return 0;
	}
	
	/* x is odd. */
	color = *fb & 0x0F;
	
	while (w-=2 > 0)
	{
		color <<= 8;
		color |= *(++fb);
		*(buf++) = color >> 4;
	}
	
	return 0;
}

