/* $Id: visual.c,v 1.12 1998/10/18 15:52:27 becka Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
  
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

int GGIdlinit(ggi_visual *visual,const char *version,void *argptr)
{
	/* Frame handling
	 */

	visual->opdraw->setreadframe=GGI_default_setreadframe;
	visual->opdraw->setwriteframe=GGI_default_setwriteframe;
	
	/* Generic drawing
	 */
	visual->opdraw->drawpixel_nc=GGIdrawpixel_nc;
	visual->opdraw->drawpixel=GGIdrawpixel;
	visual->opdraw->putpixel_nc=GGIputpixel_nc;
	visual->opdraw->putpixel=GGIputpixel;
	visual->opdraw->getpixel=GGIgetpixel;

	visual->opdraw->drawhline_nc=GGIdrawhline_nc;
	visual->opdraw->drawhline=GGIdrawhline;
	visual->opdraw->puthline=GGIputhline;
	visual->opdraw->gethline=GGIgethline;

	visual->opdraw->drawvline_nc=GGIdrawvline_nc;
	visual->opdraw->drawvline=GGIdrawvline;
	visual->opdraw->putvline=GGIputvline;
	visual->opdraw->getvline=GGIgetvline;

	visual->opdraw->copybox=GGIcopybox;

	return GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
