/* $Id: box.c,v 1.8 1998/09/20 21:22:15 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifdef _AIX
#include <sys/ioctl.h>
#include <sys/types.h>
#include <unistd.h>
#endif

#include <ggi/internal/ggi-dl.h>
#include <kgi/ioctl.h>
#include <kgi/errno.h>

#define SPEED_TRESHOLD 7

/**************/
/* draw a box */
/**************/
int GGIdrawbox(ggi_visual *vis,int x,int y,int width,int length)
{
	int RC;
	int result;

	if ( ((width  & ~SPEED_TRESHOLD) == 0) &&
	     ((length & ~SPEED_TRESHOLD) == 0) ) 
		return fallback_opdraw.drawbox(vis,x,y,width,length);
	    
	if ((RC=ioctl(vis->fd,(int)GRAPHICS_DRAWBOX,&x))<0) 
	{ 
		/* linux glibc2: errors > 4095 are returned in RC and not in errno */
		result = (RC == -1) ? errno : -RC;
		if ((result&NOSUP_MASK)==NOSUP)
		{	switch(result&AVE_MASK)
			{ case AVE_NOW:
				return fallback_opdraw.drawbox(vis,x,y,width,length);
			  default:
				return (vis->opdraw->drawbox=fallback_opdraw.drawbox)(vis,x,y,width,length);
			}
		}
	}
	return RC;
}

static int lower_fillscreen(ggi_visual *vis)
{
	return GGIdrawbox(vis,0,0,LIBGGI_VIRTX(vis),LIBGGI_VIRTY(vis));
}

/* Fill the screen.
 */
int GGIfillscreen(ggi_visual *vis)
{
	int RC;
	int result;

	if ( (RC=ioctl(vis->fd,(int)GRAPHICS_FILLSCREEN,NULL)) < 0 ) 
	{ 
		result = (RC == -1) ? errno : -RC;
		if ((result&NOSUP_MASK)==NOSUP)
		{	switch(result&AVE_MASK)
			{ case AVE_NOW:
				switch(result&AVM_MASK)
				{ case AVM_LOWER:
				  	return lower_fillscreen(vis);
				  default:
					return fallback_opdraw.fillscreen(vis);
				}
				break;
			  default:
				switch(result&AVM_MASK)
				{ case AVM_LOWER:
					return (vis->opdraw->fillscreen=lower_fillscreen)(vis);
				  default:
					return (vis->opdraw->fillscreen=fallback_opdraw.fillscreen)(vis);
				}
			}
		}
	}
	return RC;
}
