/* $Id: pixel.c,v 1.3 1998/09/20 21:22:13 marcus Exp $
***************************************************************************

   InterLeave BitMap pixel handling.

   Copyright (C) 1998 Andrew Apted   [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#define PIXEL_WADDR(vis,x,y)  \
	((uint16 *) ((uint8 *) LIBGGI_CURWRITE(vis) +  \
		(y) * LIBGGI_W_PLAN(vis).next_line) + ((x) >> 4))

#define PIXEL_RADDR(vis,x,y)  \
	((uint16 *) ((uint8 *) LIBGGI_CURREAD(vis) +  \
		(y) * LIBGGI_R_PLAN(vis).next_line) + ((x) >> 4))


int GGIputpixel_nc(ggi_visual *vis, int x, int y, ggi_pixel col)
{
	uint16 *dest = PIXEL_WADDR(vis, x, y);
	uint16 mask  = 0x8000 >> (x & 15);

	int plane_add = LIBGGI_W_PLAN(vis).next_plane / 2;
	int i;

	for (i=GT_DEPTH(LIBGGI_GT(vis)); i > 0; i--) {

		if (col & 1) {
			*dest |=  mask;
		} else {
			*dest &= ~mask;
		}

		col >>= 1; dest += plane_add;
	}
	
	return 0;
}

int GGIgetpixel(ggi_visual *vis, int x, int y, ggi_pixel *pixel)
{
	ggi_pixel col = 0;

	uint16 *dest = PIXEL_RADDR(vis, x, y);
	uint16 shift = 15 - (x & 15);

	int plane_add = LIBGGI_R_PLAN(vis).next_plane / 2;
	int i, depth  = GT_DEPTH(LIBGGI_GT(vis));

	for (i=0; i < depth; i++) {

		col |= ((*dest >> shift) & 1) << i;

		dest += plane_add;
	}

	*pixel = col;

	return 0;
}
