// fl_show_colormap.C

// Select a color from the colormap.
// Pretty much unchanged from Forms.

#include <FL/fl_show_colormap.H>
#include <FL/Fl.H>
#include <FL/Fl_Single_Window.H>
#include <FL/fl_draw.H>

#define BOXSIZE 14
#define BORDER 4

class ColorMenu : public Fl_Window {
  int initial;
  int which, previous;
  int done;
  void drawbox(int);
  void draw();
  int handle(int);
public:
  ColorMenu(int oldcol);
  int run();
};

ColorMenu::ColorMenu(int oldcol) :
  Fl_Window(BOXSIZE*8+1+2*BORDER, BOXSIZE*32+1+2*BORDER) {
  clear_border();
  set_modal();
  initial = which = oldcol;
}

void ColorMenu::drawbox(int c) {
  if (c < 0 || c > 255) return;
  int x = (c%8)*BOXSIZE+BORDER;
  int y = (c/8)*BOXSIZE+BORDER;
  fl_draw_box(c == which ? FL_DOWN_BOX : FL_BORDER_BOX,
	      x, y, BOXSIZE+1, BOXSIZE+1, c);
}

void ColorMenu::draw() {
  if (damage() != 1) {
    fl_draw_box(FL_UP_BOX,0,0,w(),h(),color());
    for (int c = 0; c < 256; c++) drawbox(c);
  } else {
    drawbox(previous);
    drawbox(which);
  }
  previous = which;
}

int ColorMenu::handle(int e) {
  int c = which;
  switch (e) {
  case FL_PUSH:
    Fl::event_is_click(0);
  case FL_MOVE:
  case FL_DRAG:
    if (Fl::event_inside(BORDER,BORDER,w()-2*BORDER-1,h()-2*BORDER-1))
      c = 8*((Fl::event_y()-BORDER)/BOXSIZE)+((Fl::event_x()-BORDER)/BOXSIZE);
    else
      c = initial;
    break;
  case FL_KEYBOARD:
    switch (Fl::event_key()) {
    case FL_Up: if (c > 7) c -= 8; break;
    case FL_Down: if (c < 256-8) c += 8; break;
    case FL_Left: if (c > 0) c--; break;
    case FL_Right: if (c < 255) c++; break;
    case FL_Escape: which = initial; done = 1; return 1;
    case FL_Enter: done = 1; return 1;
    default: return 0;
    }
    break;
  case FL_RELEASE:
    if (!Fl::event_is_click()) done = 1;
    return 1;
  default:
    return 0;
  }
  if (c != which) {
    which = c; damage(1);
    int bx = (c%8)*BOXSIZE+BORDER;
    int by = (c/8)*BOXSIZE+BORDER;
    int px = x();
    int py = y();
    if (px+bx+BOXSIZE+BORDER >= Fl::w()) px = Fl::w()-bx-BOXSIZE-BORDER;
    if (py+by+BOXSIZE+BORDER >= Fl::h()) py = Fl::h()-by-BOXSIZE-BORDER;
    if (px+bx < BORDER) px = BORDER-bx;
    if (py+by < BORDER) py = BORDER-by;
    position(px,py);
  }
  return 1;
}

extern char fl_override_redirect; // hack for menus

int ColorMenu::run() {
  if (which < 0 || which > 255) {
    position(Fl::event_x_root()-w()/2, Fl::event_y_root()-y()/2);
  } else {
    position(Fl::event_x_root()-(initial%8)*BOXSIZE-BOXSIZE/2-BORDER,
	     Fl::event_y_root()-(initial/8)*BOXSIZE-BOXSIZE/2-BORDER);
  }
  Fl::grab(*this);
  show();
  done = 0;
  while (!done) Fl::wait();
  Fl::release();
  return which;
}

int fl_show_colormap(int oldcol) {
  ColorMenu m(oldcol);
  return m.run();
}
