// Fl_Output.C

// This subclass of Fl_Input_ does not allow user to edit the output.
// Used to display output.

#include <FL/Fl.H>
#include <FL/Fl_Output.H>
#include <FL/fl_draw.H>

void Fl_Output::draw() {
  if (damage() & 128)
    draw_box(box(), Fl::focus()==this ? color2() : color());
//draw_label(); // it should never do this, since it obscures output
  Fl_Input_::drawtext(x()+Fl::box_dx(box())+3, y()+Fl::box_dy(box()),
		      w()-Fl::box_dw(box())-6, h()-Fl::box_dh(box()));
}

int Fl_Output::handle(int event) {
  if (event == FL_FOCUS) return 0;
  return Fl_Input_::handletext(event,
	x()+Fl::box_dx(box())+3, y()+Fl::box_dy(box()),
	w()-Fl::box_dw(box())-6, h()-Fl::box_dh(box()));
}
