// fl_draw.H
// Portable drawing functions

#ifndef fl_draw_H
#define fl_draw_H

#include "Enumerations.H"  // for the color names

// Colors:
void	fl_color(uchar); // select indexed color
void	fl_color(uchar, uchar, uchar); // select actual color
extern uchar fl_color_; inline uchar fl_color() {return fl_color_;}

// clip:
void fl_clip(int x, int y, int w, int h);
void fl_pop_clip();
int fl_not_clipped(int x, int y, int w, int h);
int fl_clip_box(int, int, int, int, int& x, int& y, int& w, int& h);

// rectangles tweaked to exactly fill the pixel rectangle:
void fl_rect(int x, int y, int w, int h);
void fl_rectf(int x, int y, int w, int h);

// line segments:
void fl_line(int x, int y, int x1, int y1);
void fl_line(int x, int y, int x1, int y1, int x2, int y2);

// closed line segments:
void fl_loop(int x, int y, int x1, int y1, int x2, int y2);
void fl_loop(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3);

// filled polygons:
void fl_polygon(int x, int y, int x1, int y1, int x2, int y2);
void fl_polygon(int x, int y, int x1, int y1, int x2, int y2, int x3, int y3);

// draw rectilinear lines, horizontal segment first:
void fl_xyline(int x, int y, int x1);
void fl_xyline(int x, int y, int x1, int y2);
void fl_xyline(int x, int y, int x1, int y2, int x3);

// draw rectilinear lines, vertical segment first:
void fl_yxline(int x, int y, int y1);
void fl_yxline(int x, int y, int y1, int x2);
void fl_yxline(int x, int y, int y1, int x2, int y3);

// circular lines and pie slices (code in fl_arci.C):
void fl_arc(int x,int y,int w,int h,double a1,double a2);
void fl_pie(int x,int y,int w,int h,double a1,double a2);
void fl_chord(int x,int y,int w,int h,double a1,double a2); // nyi

// scalable drawing code (code in fl_vertex.C and fl_arc.C):
void fl_push_matrix();
void fl_pop_matrix();
void fl_scale(double x, double y);
void fl_scale(double x);
void fl_translate(double x, double y);
void fl_rotate(double d);
void fl_mult_matrix(double a, double b, double c, double d, double x,double y);
void fl_begin_line();
void fl_begin_loop();
void fl_begin_polygon();
void fl_vertex(double x, double y);
void fl_curve(double, double, double, double, double, double, double, double);
void fl_arc(double x, double y, double r, double start, double a);
void fl_circle(double x, double y, double r);
void fl_end_line();
void fl_end_loop();
void fl_end_polygon();
void fl_begin_complex_polygon();
void fl_gap();
void fl_end_complex_polygon();
// get and use transformed positions:
double fl_transform_x(double x, double y);
double fl_transform_y(double x, double y);
double fl_transform_dx(double x, double y);
double fl_transform_dy(double x, double y);
void fl_transformed_vertex(double x, double y);

// current font:
void fl_font(int face, int size);
extern int fl_font_; inline int fl_font() {return fl_font_;}
extern int fl_size_; inline int fl_size() {return fl_size_;}

// information you can get about the current font:
int   fl_height();	// using "size" should work ok
int   fl_descent();
double fl_width(const char*);
double fl_width(const char*, int n);
double fl_width(uchar);

// draw using current font:
void fl_draw(const char*, int x, int y);
void fl_draw(const char*, int n, int x, int y);
void fl_draw(const char*, int x, int y, int w, int h, uchar align);
void fl_measure(const char*, int& x, int& y);

// boxtypes:
void fl_draw_box(uchar id, int x, int y, int w, int h, uchar c);

// images:
void fl_draw_image(const uchar*, int,int,int,int, int delta=3, int ldelta=0);
void fl_draw_image_mono(const uchar*, int,int,int,int, int delta=3, int ld=0);
typedef void (*Fl_Draw_Image_Cb)(void*,int,int,int,uchar*);
void fl_draw_image(Fl_Draw_Image_Cb, void*, int,int,int,int, int delta=3);
void fl_draw_image_mono(Fl_Draw_Image_Cb, void*, int,int,int,int, int delta=1);
void fl_rectf(int x, int y, int w, int h, uchar r, uchar g, uchar b);

// pixmaps:
int fl_draw_pixmap(/*const*/ char* const* data, int x,int y,uchar bg=FL_GRAY);
int fl_measure_pixmap(/*const*/ char* const* data, int &w, int &h);

// other:
const char* fl_shortcut_label(int);
void fl_overlay_rect(int,int,int,int);
void fl_overlay_clear();
void fl_cursor(uchar, uchar=FL_BLACK, uchar=FL_WHITE);

// XForms symbols:
int fl_draw_symbol(const char* label,int x,int y,int w,int h,uchar col);
int fl_add_symbol(const char* name, void (*drawit)(uchar), int scalable);

#endif
