""" Demonstration of the Pmw interface to the blt busy command.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	self.parent = parent

	if Pmw.Blt.haveblt(parent):
	    text = 'Click here to show the\nbusy cursor for one second.'
	else:
	    text = 'Sorry\nThe BLT package has not been\n' + \
		    'installed on this system.\n' + \
		    'Clicking on this button will\n' + \
		    'pause for one second but will\n' + \
		    'not display the busy cursor.'

	button = Tkinter.Button(parent,
	        text = text,
		command = Pmw.busycallback(self.sleep, parent.update))
	button.pack(padx = 10, pady = 10)

	entry = Tkinter.Entry(parent, width = 30)
	entry.insert('end', 'Try to enter some text while busy.')
	entry.pack(padx = 10, pady = 10)

    def sleep(self):
        self.parent.after(1000)

######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Busy cursor demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
