#!/usr/bin/env python
# to run this script type:
# zterm.py [prog [args ...]]
# if no program name given, use the value of the environment variable SHELL.

import sys
if sys.version[:3] == '1.4':
	import ni
from Gtkinter import *
from gnome.tty import *
import os

def child_died_event(term, prg_name, exit_status, exit_signal):
	sys.exit(0)

def main():
	win = GtkWindow()
	win.connect("delete_event", mainquit)
	win.set_title("GtkTty")
	win.set_policy(FALSE, TRUE, TRUE);

	term = GtkTty(80, 25, 50)
	term.connect("program_exit", child_died_event)
	win.add(term)
	term.show()
	term.realize()
	term.grab_focus()
	cmap = term.get_window().colormap
	# These values from GemVT
	colours = [
		#  back       fore       dim        bold
		("#000000", "#000000", "#000000", "#000000"), # black
		("#d00000", "#d00000", "#880000", "#ff0000"), # red
		("#00d000", "#00d000", "#008800", "#00ff00"), # green
		("#d0d000", "#d0d000", "#888800", "#ffff00"), # orange
		("#0000d0", "#0000d0", "#000088", "#0000ff"), # blue
		("#d000d0", "#d000d0", "#880088", "#ff00ff"), # pink
		("#00d0d0", "#00d0d0", "#008888", "#00ffff"), # cyan
		("#d0d0d0", "#d0d0d0", "#888888", "#ffffff"), # white
	]
	
	for i in range(8):
		back = cmap.alloc(colours[i][0])
		fore = cmap.alloc(colours[i][1])
		fore_dim = cmap.alloc(colours[i][2])
		fore_bold = cmap.alloc(colours[i][3])
		term.set_color(i, back.pixel, fore.pixel, fore_dim.pixel,
			       fore_bold.pixel)

	win.show()

	envp = map(lambda (x,y): x + '=' + y, os.environ.items())
	argv = sys.argv[1:]
	if not argv:
		term.execute('/usr/bin/env', ['/usr/bin/env', 'python'], envp)
	else:
		term.execute(argv[0], argv, envp)
	mainloop()

if __name__ == '__main__': main()

