/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     tifload.c                                                      *
 *            Laden von TIFF Bildern unter Bercksichtigung spezifischer     *
 *            Tags                                                           *
 * Autor:     Andreas Tille                                                  *
 * Datum:     18.06.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <stdlib.h>
#include <tiffio.h>

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

#include "paul.h"
int PaulLoadTIFF(PICTURE *bild, char *file, long flag)
/* load TIFF files and set spezific tags in the PICTURE structure
 * if only info is interesting and quiet operation is set the image data will be ignored
 * --- Parameter: ---
 * PICTURE *bild          : Bildstruktur, die Daten aufnehmen soll
 * char    *file          : Dateiname (kann != bild->file  !!!! sinnvoll??????)
 *                          (Auch zum ermitteln von bild->source bentigt!!)
 * long     flag          : nur Info oder alles?
 * --- Return: ---
 * PICTURE *bild          : Bildstruktur mit Daten 
 * int     PaulLoadTIFF() : 0 fr OK
 */
{
   TIFF          *tif;
   unsigned char *ptr, r, g, b, a;
   int            x, y;
   uint32        *rast, *tptr;
   CHUNK         *cp;
   struct tm     tmp[1];
   float         res;
   short         sval;
   char          buf[5], *s;
   
   bild->trans=0;
   if (!file) return -1;
   assert ( (tif = TIFFOpen(file, "r")) != NULL );

   if ( TIFFGetField(tif,TIFFTAG_IMAGEWIDTH,      &(bild->W)) != 1 ||
        TIFFGetField(tif,TIFFTAG_IMAGELENGTH,     &(bild->H)) != 1 ) {
      g_warning("Error while reading dimensions of %s", bild->file);
      TIFFClose(tif);
      return -1;
   }

   if ( TIFFGetField(tif,TIFFTAG_SAMPLESPERPIXEL, &x) != 1 ) {
      g_warning("Error while reading \"Samples per Pixel\"-Tag in %s", bild->file);
      bild->spp = 3;
   } else 
      bild->spp = x;
  
   if ( bild->spec ) 
      for ( cp = bild->spec; cp->key != NULL; cp++ ) {
         y = GetTag(cp->key);
         if ( TIFFTAG_PAGENUMBER == y || TIFFTAG_HALFTONEHINTS == y ) {
	    if ( TIFFGetField(tif, y, &sval) == 1 ) {
               sprintf(buf, "%i", sval);
               CopySpec(bild->spec, cp->key, buf);
	    }
            continue;
	 }
         if ( (y >= 0) && (TIFFGetField(tif, y, &s) == 1) ) 
            CopySpec(bild->spec, cp->key, s);
      }

   if ( TIFFGetField(tif, TIFFTAG_DATETIME, &s) == 1 ) {
      if ( 6 == (y = sscanf(s, "%4u:%2u:%2u %2u:%2u:%2u",
                            &(tmp->tm_year), &(tmp->tm_mon), &(tmp->tm_mday), 
		            &(tmp->tm_hour), &(tmp->tm_min), &(tmp->tm_sec))) ) {
         tmp->tm_year -= 1900;
         tmp->tm_mon  -= 1;
         bild->zeit = mktime(tmp);
      }
   }
   if ( TIFFGetField(tif, TIFFTAG_XRESOLUTION, &res) == 1 ) bild->res      = (int)res;
   if ( TIFFGetField(tif, TIFFTAG_XPOSITION, &res)   == 1 ) bild->x_offset = (int)res;
   if ( TIFFGetField(tif, TIFFTAG_YPOSITION, &res)   == 1 ) bild->y_offset = (int)res;
   
   GetPictureSpecs(bild, file);
   bild->size = bild->W * bild->H;

   if ( OnlyInfo(flag) ) {
      TIFFClose(tif);
      bild->DATA = NULL;
      return 0;
   }
   if ( !(rast = (uint32 *)_TIFFmalloc(bild->size*sizeof(uint32)) ) ) {
      TIFFClose(tif);
      return -1;
   }
   if (TIFFReadRGBAImage(tif,bild->W,bild->H,rast,0)) {
      if ( (bild->DATA = (unsigned char *)malloc(3*bild->size)) == NULL) {
         _TIFFfree(rast);
         TIFFClose(tif);
         return -1;
      }
      ptr = bild->DATA;
      for (y = 0; y < bild->H; y++) {
         tptr  = rast;
         tptr += ((bild->H - y-1) * bild->W);
         for (x = 0; x < bild->W; x++) {
            if ( IsMonochrom(bild) ) {
               *ptr++ = 0; 
               *ptr++ = TIFFGetG(*tptr++); 
               *ptr++ = 0;
            } else {
               a = TIFFGetA(*tptr);
               b = TIFFGetB(*tptr);
               g = TIFFGetG(*tptr);
               r = TIFFGetR(*tptr);
	       tptr++;
               if (a<128) {
                  *ptr++ = 255;
                  *ptr++ = 0;
                  *ptr++ = 255;
                  bild->trans=1;
               } else {
                  if ((r==255)&&(g==0)&&(b==255)) r=254;  /*???????????????????*/
                  *ptr++ = r;
                  *ptr++ = g;
                  *ptr++ = b;
               }
            }
         }
      }
   }
   _TIFFfree(rast);
   TIFFClose(tif);
   return 0;
}

