/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     savepics.c                                                     *
 *            save pictures in file bild->file.[png/tif]                     *
 * Autor:     Andreas Tille                                                  *
 * Datum:     07.05.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

#include "paul.h"

void SavePictures(GList *piclist, long flag)
/* save sets of images
 * --- Parameter: ---
 * GList *piclist : list of images, options
 * long   flag    : flag from PAUL structure to decide whether save PNG or TIFF format
 */
{
   PICTURE *bild;
   GList   *pl;
   char     filename[256];

   if ( !NBILDER(piclist) ) return;

   if ( !SaveBild(flag) ) return;
   
   for ( bild = BILD(pl = piclist); pl; bild = BILD(pl = pl->next) ) {
      if ( !bild->file ) {
	 g_warning("Picture number %i contains no name! ==> No saving possible!", pl - piclist);
	 continue;
      }
      strcat(strcpy(filename, bild->file), SavePNG(flag) ? ".png" : ".tif");
      Backup(filename);

      if ( SavePNG(flag) ) WritePNGImage(bild, filename);
      else                 WriteTIFFImage(bild, filename);
   }
}


