/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     negativ.c                                                      *
 *            Negative der Bilder erzeugen                                   *
 * Autor:     Andreas Tille                                                  *
 * Datum:     25.05.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "paul.h" 

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

void NegativBuffer(unsigned char *buf, int size, int step)
/* negiert byteweise:  b_neu = 255 - b_alt
 * --- Parameter: ---
 * unsigned char *buf : zu negierende Bytes
 * int           size : Anzahl der Bytes
 * int           step : Abstand der zu invertierenden Bytes
 * --- Rueckgabe: ---
 * unsigned char *buf : negierte Bytes
 */
{
   register unsigned char *ap, *fip;
   register int           s = step;
   
   for ( fip = (ap = buf) + size; ap < fip; ap += s )
      *ap = 255 - *ap;
}


int MakeNegative(GList *piclist)
/* negativ of a set of images, that is
 *    b_new = 255 - b_old for each color value
 * --- Parameter: ---
 * GList *piclist       : list of images
 * --- Rueckgabe: ---
 * int    MakeNegative() : 0 if OK
 */
{
   PICTURE *bild;
   GList   *pl;

   if ( !NBILDER(piclist) ) return 0;

   for ( bild = BILD(pl = piclist); pl; bild = BILD(pl = pl->next) ) {
      if ( IsMonochrom(bild) && bild->storepix == 3 ) 
         NegativBuffer(bild->DATA + 1, 3*bild->size, 3);
      else 
         NegativBuffer(bild->DATA, bild->storepix*bild->size, 1);
      CopySpec(bild->spec, ChunkNameTyp, TypNegativ);
      NewFileName(bild, APPNEGATIV);
      bild->flag |= NEGATIV;
   }
   return 0;
}

