/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     insert.c                                                       *
 *            Insert image into other image                                  *
 * Author:    Andreas Tille                                                  *
 * Datum:     25.10.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/stat.h>
#include "paul.h"

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

static int HtmlReadErr(const char *field, char *name, char *to_free, char *bname)
/* Clean after an error while parsing HTML file
 * --- Parameter: ---
 * char *field   : invalid field name 
 * char *name    : name of invalid HTML file
 * char *to_free : buffer to free
 * char *bname   : backup to put back into name
 * --- Return: ---
 * int   HtmlReadErr(): any value < 0 (-3)
 */
{
  g_warning("Invalid or missing %s field in %s", field, name);
  free(to_free);
  rename(bname, name);
  return -3;
}


static int InsertSingleImage(PICTURE *target, PICTURE *ins, int x, int y, long flag)
/* insert image into target image
 * --- Parameter: ---
 * PICTURE *target              : image to draw in
 * PICTURE *ins                 : image to insert into target
 * int      x, y                : top left corner of image to insert
 * long     flag                : HTML output or not
 * --- Return: ---
 * int      InsertSingleImage() : 0 if OK
 */
{
   register unsigned char *tp, *ip, *fap;
   register int            storepix;
   unsigned char          *trp, *irp, *frp, *ftp, *fip;
   
   if ( !IS_PICTURE(target) || !IS_PICTURE(ins) || 
        x < 0 || x >= target->W || y < 0 || y >= target->H ||
        target->storepix != ins->storepix ) return -1;

   storepix = target->storepix;
   for ( trp = target->DATA + (y*target->W + x)*storepix, irp = ins->DATA, 
         ftp = target->DATA + target->size*storepix, fip = ins->DATA + ins->size*storepix, 
         frp = target->DATA + ((y+1)*target->W)*storepix; 
         trp < ftp && irp < fip; 
         trp += target->W * storepix, irp += ins->W * storepix,
         frp += target->W * storepix )
      for ( tp = trp, ip = irp, fap = MIN(frp, tp + ins->W*storepix); tp < fap; tp++, ip++ )
         *tp = *ip;

   if ( HtmlOutput(flag) ) {
      FILE        *fp;
      struct stat  stat_buf;
      int          fh;
      char         name[MAXPATHLEN], *buf;
      const  char *kw = "keywords", *as = "<AREA SHAPE", *content = "content=";
      
      sprintf(name, "%s.html", target->file);
      if ( !target->ext ) target->ext = "png";
      if ( !ins->ext    ) ins->ext    = "html";

      if ( stat(name, &stat_buf) ) {
         assert ( (fp = fopen(name, "w")) );
         fprintf(fp, "<HTML>\n<HEAD>\n<TITLE>%s</TITLE>\n", target->file);
         if ( (buf = GetSpec(target->spec, ChunkNameAuthor)) )
            fprintf(fp, "<meta name=\"author\" content=\"%s\">\n", buf);
         fprintf(fp, "<meta name=\"%s\" %s\"%s %s %s\">\n</HEAD>\n<BODY>\n<CENTER>\n", 
                 kw, content, exename, target->file, ins->file);
         fprintf(fp, "<IMG SRC=\"%s.%s\" ALT=\"%s\" BORDER=\"0\" WIDTH=\"%i\" HEIGHT=\"%i\" usemap=\"#%s_map\">\n",
                 target->file, target->ext, target->file, target->W, target->H, target->file);
         fprintf(fp, "</CENTER>\n<MAP NAME=\"%s_map\">\n", target->file);
         fprintf(fp, "%s=\"rect\" ALT=\"%s\" COORDS=\"%i,%i,%i,%i\" HREF=\"%s.%s\">\n", as, ins->file, 
                 x, y, MIN(x+ins->W, target->W), MIN(y+ins->H, target->H), ins->file, ins->ext);
         fputs("</MAP>\n</BODY>\n</HTML>", fp);
      } else {
         char  bname[MAXPATHLEN], *buf, *ap, *ep;
         int   i;
	 
         Backup(name);
         strcat(strcpy(bname, name), "~");
         assert ( (fh  = open(bname, O_RDONLY)) > -1 );
         assert ( (buf = calloc(stat_buf.st_size+1, 1) ) );
         if ( stat_buf.st_size != ( i = read(fh, buf, stat_buf.st_size)) ) {
	    g_warning("Read only %i Bytes of %li", i, stat_buf.st_size);
	    close(fh);
	    free(buf);
	    return -2;
	 }
	 close(fh);
         assert ( (fp = fopen(name, "w")) );
         ap = buf;
         if ( !(ep = strstr(ap, kw)) )  return HtmlReadErr(kw, name, buf, bname);
         if ( !(ep = strstr(ep, content)) ) return HtmlReadErr(kw, name, buf, bname);
	 if ( !(ep = strchr(ep, '"')) ) return HtmlReadErr(kw, name, buf, bname);
	 if ( !(ep = strchr(++ep, '"')) ) return HtmlReadErr(kw, name, buf, bname);
         *ep = 0;
	 fputs(ap, fp);
	 fprintf(fp, " %s\"", ins->file);
         ap = ep + 1;
         if ( !(ep = strstr(ap, as)) ) return HtmlReadErr(as, name, buf, bname);
         *ep = 0;
	 fputs(ap, fp);
         *(ap = ep) = *as;
         fprintf(fp, "%s=\"rect\" ALT=\"%s\" COORDS=\"%i,%i,%i,%i\" HREF=\"%s.%s\">\n", as, ins->file, 
                 x, y, MIN(x+ins->W, target->W), MIN(y+ins->H, target->H), ins->file, ins->ext);
	 fputs(ap, fp);
         free(buf);
      }
      fclose(fp);
   }
   
   return 0;
}

int InsertImage(PAUL *p)
/* insert operation image into each image in image list
 * --- Parameter: ---
 * PAUL *p             : image structure
 * --- Return: ---
 * int   InsertImage() : 0 if OK
 */
{
   PICTURE *bild;
   GList   *pl;

   if ( !p || !NBILDER(p->piclist) || !(p->op) || !IS_PICTURE(p->op) ) return 0;

   for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) 
      InsertSingleImage(bild, p->op, p->opt->xi, p->opt->yi, p->opt->f);

   return 0;
}

