/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Verwendet: GTK, Imlib                                                     *
 * Modul:     animate.c                                                      *
 *            animation related functions for paul                           *
 * Autor:     Andreas Tille                                                  *
 * Datum:     03.09.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <stdlib.h>
#include "paul.h"
#include "callback.h"

int           ANIMATION_SPEED = SINGLE;
static int    TIMEOUT_TAG = 0;
const  gchar *PICTURE_DataKey="PICTURE_DataKey";

static int ANIFLAG = 0;

static int Animation(PAUL *p)
/* timeout-function for animation
 * --- parameter: ---
 * PAUL *p         : animation structure containing window and picture ring-list
 * --- return:    ---
 * int  Animation(): 0 in case of error
 */
{
   if ( ANIFLAG ) return 1;  /* avoid displaying if timout is faster than display */
   
   ANIFLAG  = 1;
   ApplyPicture((p->show)->window, BILD(p->activ));
   p->activ = (p->activ)->next;
   ANIFLAG  = 0;

   return 1;
}

static int InstallTimeout(PAUL *p)
{
   register long       wait;

   if ( p->opt->sek < 0.01 ) wait = 0; /* about 0.01 seconds needs calculation */
   else                      wait = 1000*(p->opt->sek) - 10; 

   /* add some integer to wait to enable keyboard input in image window */
   TIMEOUT_TAG = gtk_timeout_add(wait, (GtkFunction)Animation, p);
   
   if ( wait > FAST_TIME ) ANIMATION_SPEED = SLOW_ANIMATION;
   else {
      ANIMATION_SPEED = FAST_ANIMATION;
      SHOW_SLOW       = 0;
      gdk_window_set_title((p->show)->window, "Paul animation");
   }
   
   gtk_widget_set_sensitive(p->w, FALSE);
   return TIMEOUT_TAG;
}

static void AnimationTimeChanged(GtkWidget *widget, PAUL *p)
/* called when parameter of animation time was changed in menu
 * --- Parameter: ---
 * GtkButton *button: OK-Button of menu window for animation time
 *                    PAUL *p connected
 * gpointer   data  : spin button which holds new value
 */
{
   if ( TIMEOUT_TAG ) {
      gtk_timeout_remove(TIMEOUT_TAG);
      InstallTimeout(p);
   }
}

void AnimationTimeParameterCallback(GtkWidget *widget, PAUL *p)
{
   PARA_IN *para_in;
   ITEM    *para;
   
   assert ( (para_in = malloc(sizeof(PARA_IN))) );
   
   para_in->title = "Animation parameter";
   para_in->frame = "Animation";
   para_in->np    = 1;
   
   assert ( (para    = malloc(para_in->np*sizeof(ITEM))) );
   para->name     = "Delay time [s]:";
   para->typ      = P_DOUBLE;
   if ( p->opt->sek <= 0 ) p->opt->sek = 0.0;
   para->val      = &(p->opt->sek);
   para->upper    = 10000.0;
   para->lower    = 0.0;
   para->valchg   = NULL;
   para->adj      = NULL;
   
   para_in->para = para;
   
   BuildParameterInput(para_in, p, GTK_SIGNAL_FUNC(AnimationTimeChanged));
}

static GList *SortList(GList *list, GList *reflist)
/* sort a given GList *list according to the sequence of Data in GList *reflist
 * Each element of reflist in ascending order is checked, if it is contained in
 * list.  Then it goes into the newly created sorted list.
 * --- Parameter: ---
 * GList *list       : list to sort
 * GList *reflist    : reference list
 * --- return: ---
 * GList *SortList() : sorted list
 */
{
   register gpointer data;
   register GList   *rl, *ll, *new = NULL;
   int               i;
   
   if ( !reflist || !list ) return NULL;
   for ( rl = reflist; rl; rl = rl->next ) {
      if ( !(data = rl->data) ) continue;
      for ( ll = list; ll; ll = ll->next ) 
	 if ( ll->data == data ) break;
      if ( !ll ) continue;
      new = g_list_append(new, data);
   }
   if (  ( i = g_list_length(list) - g_list_length(new) ) )
      g_warning("%i elements lost in new list\n", i);
      
   g_list_free(list);
   return new;
}

void PictureAnimate(GtkWidget *button, PAUL *p)
/* prepares animation
 * --- Parameter: ---
 * GtkWidget *button: button at bottom line (can be ignored)
 * PAUL      *p     :
 */
{
   register GList *pl = NULL, *sellist;
   PICTURE        *check_activ;
   int             x = -1, y = -1;

   sellist = (p->filelist)->selection;
   if ( !sellist || !(sellist->next) ) {
      g_warning("Please select at least two images to animate\nusing middle or right mouse button.");
      return;
   }

   if ( !(check_activ = BILD(p->activ)) ) {
      g_warning("Please check image selection.");
      return;
   }
   
   while (sellist) {
      GtkObject         *list_item;
      register  PICTURE *bild;
	
      list_item = GTK_OBJECT(sellist->data);
      if ( (bild = LI2BILD(list_item)) ) {
         if ( p->opt->sek < FAST_TIME  ) {
            if ( x == -1 ) {
	       x = bild->W;
	       y = bild->H;
            } else {
               if ( x != bild->W || y != bild->H ) {
                  g_warning("Please make sure that all images have the same size.\nThis is neccessary for animation speed under %gs.", (double)FAST_TIME);
                  g_list_free(pl);
                  return;
	       }
	    }
	 }
         if ( bild == check_activ ) check_activ = NULL;
         pl      = g_list_append(pl, bild);
         g_return_if_fail( list_item == GTK_OBJECT((bild->label)->parent) ); 
         sellist = sellist->next;
      }
   }
   if ( check_activ ) { /* if p->activ isnt selected */
      p->activ = LI2PL(GTK_OBJECT(((p->filelist)->selection)->data));
      if ( p->opt->sek < FAST_TIME  ) /* Make sure, that image size of selected images is OK */
         ApplyPicture((p->show)->window, BILD(p->activ));
   }
   
   sellist = pl;
   sellist = SortList(sellist, p->piclist);

   (pl = g_list_last(sellist))->next = sellist; /* ringlist !! */
   sellist->prev = pl;
   p->activ = g_list_find(sellist, (p->activ)->data);
   InstallTimeout(p);

   SetAnimateButton(p, GTK_SIGNAL_FUNC(StopPictureAnimate), STOP);
}

void StopPictureAnimate(GtkWidget *button, PAUL *p)
/* stopps animation
 * --- Parameter: ---
 * GtkWidget *button: animation button
 * PAUL      *p
 */
{
   register GList     *pl;

   gtk_timeout_remove(TIMEOUT_TAG);
   TIMEOUT_TAG = 0;
   
   pl = g_list_find(p->piclist, (p->activ)->data);

   ((p->activ)->prev)->next = NULL;  /* open ring!! */
   g_list_free(p->activ);
   p->activ = pl;
   if ( ANIMATION_SPEED == FAST_ANIMATION ) {
      gdk_window_set_title((p->show)->window, (BILD(pl))->file);
      gdk_window_show((p->show)->window);
      SHOW_SLOW = 1;
   }
   ANIMATION_SPEED = SINGLE;
   gtk_widget_set_sensitive(p->w, TRUE);

   SetAnimateButton(p, GTK_SIGNAL_FUNC(PictureAnimate), ANIMATE);
}


