/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"

static gchar *filename_from_path(char *t)
{
        char *p;

        p = t + strlen(t);
        while(p > t && p[0] != '/') p--;
        p++;
        return p;
}

static gint sort_list_cb(void *a, void *b)
{
        return strcmp((gchar *)a, (gchar *)b);
}

static void populate_dir_clist(GtkWidget *clist, gchar *path)
{
        DIR *dp;
        struct dirent *dir;
        struct stat ent_sbuf;
        gchar *buf[] = { "x", };
        GList *path_list = NULL;
        GList *list;

        if((dp = opendir(path))==NULL)
                {
                /* dir not found */
                return;
                }
        while ((dir = readdir(dp)) != NULL)
                {
                /* skips removed files */
                if (dir->d_ino > 0)
                        {
                        gchar *name = dir->d_name;
			gchar *filepath = g_strconcat(path, "/", name, NULL);
                        if (stat(filepath,&ent_sbuf) >= 0 && S_ISDIR(ent_sbuf.st_mode))
                                {
                                path_list = g_list_insert_sorted(path_list,
                                                g_strdup(name),
                                                (GCompareFunc) sort_list_cb);
                                }
			g_free(filepath);
                        }
		}
        closedir(dp);

	gtk_clist_freeze(GTK_CLIST(clist));
	gtk_clist_clear(GTK_CLIST(clist));

        list = path_list;
        while (list)
                {
		gint row;
		gchar *filepath;
		if (strcmp(list->data, ".") == 0)
			{
			filepath = g_strdup(path);
			}
		else if (strcmp(list->data, "..") == 0)
			{
			gchar *p;
			filepath = g_strdup(path);
			p = filename_from_path(filepath);
			if (p - 1 != filepath) p--;
			p[0] = '\0';
			}
		else if (strcmp(path, "/") == 0)
			{
			filepath = g_strconcat("/", list->data, NULL);
			}
		else
			filepath = g_strconcat(path, "/", list->data, NULL);
		
		buf[0] = list->data;
		row = gtk_clist_append(GTK_CLIST(clist),buf);
		gtk_clist_set_row_data_full(GTK_CLIST(clist), row,
					    filepath, (GtkDestroyNotify) g_free);
                g_free(list->data);
                list = list->next;
                }

        g_list_free(path_list);

	gtk_clist_thaw(GTK_CLIST(clist));
}

static void dir_select_cb(GtkWidget *clist, gint row, gint column,
			  GdkEventButton *bevent, gpointer data)
{
	GtkWidget *entry = data;
	gchar *path = g_strdup(gtk_clist_get_row_data(GTK_CLIST(clist), row));
	gtk_entry_set_text(GTK_ENTRY(entry),path);
	populate_dir_clist(clist, path);
	g_free(path);
}


GtkWidget *destination_widget_new(gchar *path, GtkWidget *entry)
{
	GtkWidget *clist;
	clist=gtk_clist_new (1);
        gtk_clist_set_policy (GTK_CLIST (clist), GTK_POLICY_ALWAYS, GTK_POLICY_AUTOMATIC); 
        gtk_signal_connect (GTK_OBJECT (clist), "select_row",(GtkSignalFunc) dir_select_cb, entry);
        gtk_widget_show (clist);

	populate_dir_clist(clist, path);

	return clist;
}
