/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    create a window

    Copyright (c) 1997-1998 Mark Danks.
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_GEMWINCREATE_H_
#define INCLUDE_GEMWINCREATE_H_

#ifdef unix
#include <GL/glx.h>
#elif _WINDOWS
#include <windows.h>
#else
#error Define OS specific window creation
#endif

#include "Base/CPPExtern.h"


/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    WindowInfo
    
    All of the relavent information about an OpenGL window

DESCRIPTION
    
-----------------------------------------------------------------*/
class GEM_EXTERN WindowInfo
{
	public:
	
		// Constructor
		WindowInfo() :
#ifdef unix
            dpy(NULL), win(NULL), cmap(NULL), context(NULL)
#elif _WINDOWS
            win(NULL), dc(NULL), context(NULL)
#endif
            {}

#ifdef unix

		Display     *dpy;               // X Display
		Window      win;                // X Window
		Colormap    cmap;               // X color map
		GLXContext  context;            // OpenGL context

#elif _WINDOWS

		HWND        win;                // Window handle
		HDC         dc;                 // Device context handle
		HGLRC       context;            // OpenGL context

#else
#error Define OS specific window data
#endif

};

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    WindowHints
    
    Hints for window creation

DESCRIPTION
    
-----------------------------------------------------------------*/
class GEM_EXTERN WindowHints
{
	public:

        //////////
        // Should the window be realized
		int         actuallyDisplay;

        //////////
        // Single or double buffered
		int         buffer;

        //////////
        // The width/x of the window
		int         width;

        //////////
        // The height/y of the window
		int         height;

        //////////
        // The GLXcontext to share rendering with
#ifdef unix
		GLXContext  shared;
#elif _WINDOWS
		HGLRC       shared;
#else
#error Define OS specific OpenGL context
#endif
};

//////////
// Create a new window
GEM_EXTERN extern int createGemWindow(WindowInfo &info, WindowHints &hints);

//////////
// Destroy a window
GEM_EXTERN extern void destroyGemWindow(WindowInfo &info);

#endif  // for header file
