
/*
    xskat - a card game for 1 to 3 players.
    Copyright (C) 1998  Gunter Gerhardt

    This program is free software; you can redistribute it freely.
    Use it at your own risk; there is NO WARRANTY.
*/

#define TEXT_C

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "defs.h"
#include "text.h"

#define VERSION   " X S K A T   2.3.1 "
#define COPYRIGHT "Copyright 1998  Gunter Gerhardt"
#define EMAIL     "(gerhardt@draeger.com)"

static char *ger_text[]={
  "Null","Karo","Herz","Pik","Kreuz","Grand","Ramsch",
  "As","10","Knig","Dame","Bube","9","8","7",
  " A"," 10"," K"," D"," B"," 9"," 8"," 7",
  "Hand gespielt","Schneider angesagt","Schwarz angesagt",
  "Ouvert gespielt","Ouvert Hand gespielt",
  "Passe","Ja","Nein","Spieler%d","Computer","links","rechts",
  "Drcken","spielt ","ouvert Hand","ouvert","Hand","Ouvert",
  "berlegt","Gereizt bis: %d","Lschen"," spielte ",
  "Gewonnen"," gewann ","Verloren"," verlor ","%d Augen",
  "berreizt !","Gegner nicht Schneider !","Gegner nicht schwarz !",
  "Eine Jungfrau !","Durchmarsch !",
  "Niemand","gewinnt","verliert","den Ramsch",
  "das Nullspiel.","das Spiel schwarz !","mit %d zu %d Augen.",
  " Hand ? "," Spiel beenden ? "," Spielende ","beendet das Spiel","Aha",
  " Lschen ? "," Spiel ","Schneider","Schwarz","Spielen"," Hinweis ",
  "Nur bei Handspielen kann Schneider",
  "oder schwarz angesagt werden.",
  "Ouvert schliet schwarz angesagt",
  "ein (auer bei Null natrlich).",
  "Du hast hher gereizt als der",
  "Wert des angesagten Spiels !",
  "Null:23  Null ouvert:46",
  "Null Hand:35  Null ouvert Hand:59",
  "Revolution:92",
  " Angesagt ist "," Resultat ","Der Spielwert ist","Ende",
  "Protokoll","Weiter"," Protokoll ",
  "Im Skat ist:",
  "Im Skat war:",
  "Gereizt bis:",
  "Gewonnen mit:",
  "Verloren mit:",
  "Spielliste"," Spielliste ",VERSION,
  COPYRIGHT,EMAIL,
  "Sortieren","Aufwrts","Abwrts","Alternierend","Sequentiell",
  "Normal",
  "Gereizt bis:","Gespielt wird:","Letzter Stich:","Gedrckt:",
  "Du bist dran !","Vordefiniertes Spiel","Speichern",
  "Dieses Programm ist freie Software;",
  "es kann frei verbreitet werden.",
  "Verwendung auf eigenes Risiko;",
  "es gibt KEINE GARANTIE.",
  "Optionen"," Computer-Strategie ","passe","sage 18",
  " Varianten ",
  "Ramsch spielen","Immer",
  "Schieberamsch"," Skat aufnehmen ? ","Fertig",
  "Buben drfen nicht geschoben werden.",
  " Spielwert verdoppelt ","nimmt den Skat nicht auf.","klopft !",
  "VH schob:","MH schob:","HH schob:",
  "Kontra sagen","mit Kontra","ab 18","Kontra"," Kontra ! ","Re","von ",
  "Wiederholen"," Spiel wiederholen ","mit den Karten von","mir",
  "Vorhand wechselt:",
  " Verzgerung ","Nimm Stich nach:","Sekunden","Maus-Klick",
  "Bock-Runden","+Ramsch","fortsetzen",
  " Bock-Ereignisse ","Bock-Ereignis","%d Bock-Ereignisse",
  "Bock-Spiele:"," Grand Hand ? ",
  "Verloren mit 60 Augen","Grand Hand gewonnen",
  "Erfolgreicher Kontra","Kontra & Re angesagt",
  "NNN Punkte in Spielliste","N00 Punkte in Spielliste",
  "Spielwert ist >= +72","Spielwert ist >= +96",
  " Men-Button ","Jeder",
  "Spitze","zhlt 2","Spitze verloren !","Spitze !",
  "Spitze nicht erlaubt !",
  "Niedrigster Trumpf nicht auf der Hand.",
  "Grand mit 4 Buben.",
  "Null ist dicht !"," Null ist dicht ! ","Karten aufdecken ?",
  "Revolution","Revolution: Karten austauschen !",
  "Vorhand","Mittelhand","Hinterhand",
  "Klopfen"," Klopfen ","Spielwert verdoppeln ?",
  "Schenken"," Schenken ","Spiel verloren geben ?","Geschenk annehmen ?",
  "Mitspieler lehnt ab.","Gegner geben auf.","Annehmen",
  "Geben","Schnell","Langsam"
};

static char *eng_text[]={
  "Null","Diamond","Heart","Spade","Club","Grand","Ramsch",
  "Ace","10","King","Queen","Jack","9","8","7",
  " A"," 10"," K"," Q"," J"," 9"," 8"," 7",
  "Played Hand","Schneider announced","Schwarz announced",
  "Played ouvert","Played ouvert Hand",
  "Pass","Yes","No","Player%d","Computer","left","right",
  "Done","plays ","ouvert Hand","ouvert","Hand","Ouvert",
  "thinks","You have bid: %d","Clear"," played ",
  "Won"," won ","Lost"," lost ","%d points",
  "Overbid !","Opponents not Schneider !","Opponents not schwarz !",
  "One virgin !","Forced march !",
  "Nobody","wins","loses","the Ramsch",
  "the Null game.","the game schwarz !","with %d vs %d points.",
  " Hand ? "," Quit game ? "," Game over ","quits the game","OK",
  " Clear ? "," Game ","Schneider","Schwarz","Play"," Reminder ",
  "Only when playing Hand you may",
  "say Schneider or schwarz.",
  "Ouvert includes schwarz",
  "(except when playing Null).",
  "The value of your game",
  "is not high enough !",
  "Null:23  Null ouvert:46",
  "Null Hand:35  Null ouvert Hand:59",
  "Revolution:92",
  " Playing "," Result ","The value of the game is","Quit",
  "Log","Continue"," Log ",
  "Skat is:",
  "Skat was:",
  "Last bid:",
  "Won with:",
  "Lost with:",
  "Game list"," Game list ",VERSION,
  COPYRIGHT,EMAIL,
  "Sort","Up","Down","Alternating","Sequential",
  "Normal",
  "Bidding:","Playing:","Last trick:","Skat:",
  "It's your turn !","predefined game","Save",
  "This program is free software;",
  "you can redistribute it freely.",
  "Use it at your own risk;",
  "there is NO WARRANTY.",
  "Options"," Computer strategy ","pass","say 18",
  " Variations ",
  "Play Ramsch","Always",
  "Schieberamsch"," Pick up Skat ? ","Done",
  "It's not allowed to pass on jacks.",
  " Game score doubled ","doesn't pick up the Skat.","knocks !",
  "FH passed:","MH passed:","RH passed:",
  "Say Kontra","with Kontra","if 18","Kontra"," Kontra ! ","Re","by ",
  "Replay"," Replay game ","with the cards from","me",
  "Forehand changes:",
  " Delay ","Take trick after:","seconds","mouse click",
  "Bockrounds","+Ramsch","resume",
  " Bock events ","Bock event","%d Bock events",
  "Bock games:"," Grand Hand ? ",
  "Lost with 60 points","Successful Grand Hand",
  "Successful Kontra","Kontra & Re game",
  "NNN points in game list","N00 points in game list",
  "Game value is >= +72","Game value is >= +96",
  " Menu button ","Any",
  "Spitze","counts 2","Lost Spitze !","Spitze !",
  "Spitze not allowed !",
  "Lowest trump not in your hand.",
  "Grand with 4 jacks.",
  "Null is safe !"," Null is safe ! ","Show your cards ?",
  "Revolution","Revolution: exchange cards !",
  "Forehand","Middlehand","Rearhand",
  "Klopfen"," Klopfen ","Double game value ?",
  "Schenken"," Schenken ","Give up the game ?","Accept the gift ?",
  "Partner disagrees.","Opponents give up.","Accept",
  "Deal","Fast","Slow"
};

static struct {
  char **arr;
  char *name;
} textdesc[] = {
  {ger_text,"german"},
  {eng_text,"english"}
};

VOID init_text()
{
  textarr=textdesc[lang].arr;
}

int langidx(s,def)
char *s;
int def;
{
  char h[80];
  int i;

  for (i=0;i<79 && s && *s;i++,s++) {
    h[i]=tolower(*s);
  }
  h[i]=0;
  for (i=0;i<sizeof(textdesc)/sizeof(textdesc[0]);i++) {
    if (!strcmp(textdesc[i].name,h)) return i;
  }
  if (s) {
    fprintf(stderr,"Unknown language '%s'.  Try one of:",h);
    for (i=0;i<sizeof(textdesc)/sizeof(textdesc[0]);i++) {
      if (i) fputc(',',stderr);
      fprintf(stderr," %s",textdesc[i].name);
    }
    fputs(".\n",stderr);
  }
  if (!def) {
    return -1;
  }
  for (i=0;i<sizeof(textdesc)/sizeof(textdesc[0]);i++) {
    if (!strcmp(textdesc[i].name,DEFAULT_LANGUAGE)) return i;
  }
  return 0;
}
