#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>

#include "../colorlist.h"

#define CSIZE 32
#define DPD 10
#define CMAP 9

Display *d;
static Window w ,r,child,gw;
static GC gc;
static XColor clr[COLORNUM];
static XImage *xi;
static XEvent e;
static Font fnt;
static Colormap cmap;
static char working[CSIZE][CSIZE];
static char cbuff[CMAP*CMAP][CSIZE][CSIZE];
static Visual *vis;
static xy[5][4] = {
      {0,0,320,320},
      {0,640,899,689},
      {0,720,899,750},
      {330,199,330+CSIZE*CMAP,200+CSIZE*CMAP},
      {0,750,899,780}
};

static int pen = 1;

void MakeColor()
{
      int i;
      
      for(i = 0 ; i < COLORNUM ; i++)
	{
	      clr[i].red = rgb[i][0]*256;
	      clr[i].green = rgb[i][1]*256;
	      clr[i].blue = rgb[i][2]*256;
	      clr[i].flags = DoRed|DoGreen|DoBlue;
	      clr[i].pixel = i;
	      
	}    
      XStoreColors(d,cmap,clr,COLORNUM);
      
}

void Save()
{
      char filename[256];
      FILE *fp;
      int i;
      
      
      fprintf(stderr,"filename for image data ? ");
      scanf("%s",filename);
      
      if((fp = fopen(filename,"w")) == NULL)
	{
	      fprintf(stderr,"Open Error !!\n");
	      return ;
	}
      
      if(fwrite(working ,CSIZE*CSIZE,1,fp) != 1)
	{
	      fprintf(stderr,"Write Error !!\n");
	      return ;
	}
      fclose(fp);
}

void Load()
{
      char filename[256];
      FILE *fp;
      int i;
      
      
      fprintf(stderr,"filename for image data ? ");
      fscanf(stdin,"%s",filename);
      
      if((fp = fopen(filename,"r")) == NULL)
	{
	      fprintf(stderr,"Open Error !!\n");
	      return ;
	}
      
      if(fread(working,CSIZE*CSIZE,1,fp) != 1)
	{
	      fprintf(stderr,"Read Error !!\n");
	      return ;
	}
      fclose(fp);
}

void Redraw()
{
      int x,y;
      int i;
      
      for(y=0;y<CSIZE;y++)
	for(x=0;x<CSIZE;x++)
	  {
		if(working[y][x] == 100)
		  {
			XSetForeground(d,gc,clr[0].pixel);
			XFillRectangle(d,w,gc,x*DPD,y*DPD,DPD-1,DPD-1);
			XDrawPoint(d,w,gc,x+100,y+800);
			XSetForeground(d,gc,clr[COLORNUM-1].pixel);
			XDrawLine(d,w,gc,x*DPD,y*DPD,x*DPD+DPD,y*DPD+DPD);
		  }
		else
		  {
			XSetForeground(d,gc,clr[working[y][x]].pixel);
			XFillRectangle(d,w,gc,x*DPD,y*DPD,DPD-1,DPD-1);
			XDrawPoint(d,w,gc,x+100,y+800);
		  }
	  }
      for(x=0;x<CSIZE;x+=4) {
            XSetForeground(d,gc,clr[COLORNUM-1].pixel);
	    XFillRectangle(d,w,gc,x*DPD-2,0,2,DPD*32+5);
	    XFillRectangle(d,w,gc,0,x*DPD-2,DPD*32+5,2);

      }
      
}

void Clear()
{
      int x,y;
      int i;
      
      XSetForeground(d,gc,clr[0].pixel);
      XFillRectangle(d,w,gc,0,0,320,320);
      XFlush(d);
      
      for(y=0;y<CSIZE;y++)
	for(x=0;x<CSIZE;x++)
	  {
		working[y][x] = 100;
		XSetForeground(d,gc,clr[COLORNUM-1].pixel);
		XDrawLine(d,w,gc,x*DPD,y*DPD,x*DPD+DPD,y*DPD+DPD);
		
	  }
      for(x=0;x<CSIZE;x+=4) {
	    XSetForeground(d,gc,clr[COLORNUM-1].pixel);
	    XFillRectangle(d,w,gc,x*DPD-2,0,2,DPD*32+5);
	    XFillRectangle(d,w,gc,0,x*DPD-2,DPD*32+5,2);
      }
      
      XSetForeground(d,gc,clr[0].pixel);
      XFillRectangle(d,w,gc,100,800,64,64);
      XFlush(d);
}

void InitWin()
{
      d = XOpenDisplay(NULL);
      w = XCreateSimpleWindow(d,RootWindow(d,0),100,100,640,900,2,0,0);
      vis = DefaultVisual(d,0);

      gc = XCreateGC(d,w,0,0);
      fnt=XLoadFont(d,"12x24");
      XSetFont(d,gc,fnt);
      XMapWindow(d,w);
      cmap = XCreateColormap(d,w,vis,AllocAll); 
      XSetWindowColormap(d,w,cmap);

      XSelectInput(d,w,ButtonPressMask | ButtonReleaseMask | ExposureMask);
      MakeColor();
      XFlush(d);
}

void Menu()
{
      int i;

      XSetForeground(d,gc,clr[0].pixel);
      XFillRectangle(d,w,gc,100,800,64,64);
      
      XSetForeground(d,gc,clr[16].pixel);
      XFillRectangle(d,w,gc,0,640,640,260);
      XDrawRectangle(d,w,gc,556,0,41,41);
      XDrawRectangle(d,w,gc,329,199,590,520);
      XFlush(d);

      XSetForeground(d,gc,clr[0].pixel);
      XFillRectangle(d,w,gc,100,800,64,64);
      
      XDrawString(d,w,gc,0,750,"Save",4);
      XDrawString(d,w,gc,80,750,"Load",4);
      XDrawString(d,w,gc,160,750,"Clear",5);
      XDrawString(d,w,gc,240,750,"Pen+",4);
      XDrawString(d,w,gc,320,750,"Pen-",4);
      XDrawString(d,w,gc,400,750,"RLeft",5);
      XDrawString(d,w,gc,480,750,"RRight",6);
      XDrawString(d,w,gc,0,780,"RotUp",5);
      XDrawString(d,w,gc,80,780,"RDown",5);
      XDrawString(d,w,gc,160,780,"Rotat1",6);
      XDrawString(d,w,gc,240,780,"Rotat2",6);
      XDrawString(d,w,gc,320,780,"Rotat3",6);

      for(i=0;i<COLORNUM;i++)
	{
	      XSetForeground(d,gc,clr[i].pixel);
	      XFillRectangle(d,w,gc,i*10,640,10,49);
	}
      XFlush(d);
}

void PutDot(mx,my,color)
int mx,my,color;
{
      int x,y;

      mx /= DPD;
      my /= DPD;

      working[my][mx] = color;
      XSetForeground(d,gc,clr[color].pixel);
      
      for(y = my ; y < my + pen ; y++)
	for(x = mx ; x < mx + pen ; x++)
	  {
		if(x < CSIZE && y < CSIZE)
		  {
			working[y][x] = color;
			XFillRectangle(d,w,gc,x*DPD,y*DPD
				       ,DPD-2,DPD-2);
			XFillRectangle(d,w,gc,x+100,y+800,1,1);
		  }
	  }
}

void EraseDot(mx,my)
     int mx,my;
{
      int x,y;
      
      mx /= DPD;
      my /= DPD;

      working[my][mx] = 100;

      XSetForeground(d,gc,clr[0].pixel);
      for(y = my ; y < my + pen ; y++)
	for(x = mx ; x < mx + pen ; x++)
	  {
		if(x < CSIZE && y < CSIZE)
		  {
			working[y][x] = 100;
			XSetForeground(d,gc,clr[0].pixel);
			XFillRectangle(d,w,gc,x*DPD,y*DPD,DPD-2,DPD-2);
			XSetForeground(d,gc,clr[COLORNUM-1].pixel);
			XDrawLine(d,w,gc,x*DPD,y*DPD,x*DPD+DPD-1,y*DPD+DPD-1);
			XSetForeground(d,gc,clr[0].pixel);
			XDrawPoint(d,w,gc,x+100,y+800);
			
		  }
	  }
      
}

void DrawPenLength(pen)
     int pen;
{
      XSetForeground(d,gc,clr[0].pixel);
      XFillRectangle(d,w,gc,550,90,100,100);
      XSetForeground(d,gc,clr[3].pixel);
      XFillRectangle(d,w,gc,550,90,pen*DPD,pen*DPD);
}

void Rotat90()
{
      static char tmp[CSIZE][CSIZE];
      int x,y;

      memcpy(tmp,working,sizeof(tmp));
      
      for(y = 0 ; y < CSIZE ; y++)
	for(x = 0 ; x < CSIZE ; x++)
	  working[x][CSIZE-y] = tmp[x][y];
      u_sleep(500000);
}

void Rotat91()
{
      static char tmp[CSIZE][CSIZE];
      int x,y;

      memcpy(tmp,working,sizeof(tmp));
      
      for(y = 0 ; y < CSIZE ; y++)
	for(x = 0 ; x < CSIZE ; x++)
	  working[CSIZE-x][y] = tmp[x][y];
      u_sleep(500000);
}

void Rotat92()
{
      static char tmp[CSIZE][CSIZE];
      int x,y;

      memcpy(tmp,working,sizeof(tmp));

      for(y = 0 ; y < CSIZE ; y++)
        for(x = 0 ; x < CSIZE ; x++)
          working[x][y] = tmp[y][x];
      u_sleep(500000);
}



void Shift(dx)
     int dx;
{
      static char tline[CSIZE];
      int x,y;

      switch(dx)
	{
	    case 1:
	      for(y = 0 ; y < CSIZE ; y++)
		tline[y] = working[y][CSIZE-1];
	      
	      for(x = CSIZE -2 ; x >= 0 ; x--)
		for(y = 0 ; y < CSIZE ; y++)
		  working[y][x+1] = working[y][x];
	      
	      for(y = 0 ; y < CSIZE ; y++)
		working[y][0] = tline[y];
	      break;
	      
	    case 0:
	      for(y = 0 ; y < CSIZE ; y++)
                tline[y] = working[y][0];
	      
              for(x = 1 ; x < CSIZE ; x++)
                for(y = 0 ; y < CSIZE ; y++)
                  working[y][x-1] = working[y][x];
	      
              for(y = 0 ; y < CSIZE ; y++)
                working[y][CSIZE-1] = tline[y];
	      break;

	    case 2:
	      for(x = 0 ; x < CSIZE ; x++)
		tline[x] = working[0][x];

	      for(y = 1 ; y < CSIZE ; y++)
		for(x = 0 ; x < CSIZE ; x++)
		  working[y-1][x] = working[y][x];

	      for(x= 0 ; x < CSIZE ; x++)
		working[CSIZE -1][x] = tline[x];
	      break;

	    case 3:
	      for(x = 0 ; x < CSIZE ; x++)
                tline[x] = working[CSIZE-1][x];

              for(y = CSIZE -1 ; y >= 0  ; y--)
                for(x = 0 ; x < CSIZE ; x++)
                  working[y][x] = working[y-1][x];

              for(x= 0 ; x < CSIZE ; x++)
                working[0][x] = tline[x];
	      break;

	    default:
	      ;
	      
	}
      Redraw();
      u_sleep(350000);
}
      
void GetMenu(mx,my)
     int mx,my;
{
      mx /= 80;
      
      switch(mx)
	{
	    case 0:
	      Save();
	      break;
	      
	    case 1:
	      Load();
	      Redraw();
	      break;

	    case 2:
	      Clear();
	      break;
	      
	    case 3:
	      if(pen < 10)
		{
		      pen++;
		      DrawPenLength(pen);
		}
	      fprintf(stderr,"%d \n",pen);
	      u_sleep(53000);
	      break;

	    case 4:
	      if(pen > 1)
		{
		      pen--;
		      DrawPenLength(pen);
                }

	      fprintf(stderr,"%d \n",pen);
              u_sleep(50300);
              break;

	    case 5:
	      Shift(0);
	      break;

	    case 6:
	      Shift(1);
	      break;

	      
	    default:
	      ;
	}
}

void GetMenu2(mx,my)
     int mx,my;
{
      mx /= 80;

      switch(mx)
	{
	    case 0:
	      Shift(2);
	      break;
	      
	    case 1:
	      Shift(3);
	      break;
	    case 2:
	      Rotat90();
	      break;
	    case 3:
	      Rotat91();
              break;
	    case 4:
	      Rotat92();
              break;

	}
      
      Redraw();
}

void PutClrCsr(x)
     int x;
{
      XSetForeground(d,gc,clr[18].pixel);
      XFillRectangle(d,w,gc,x*10,690,10,5);
}

void EraseClrCsr(x)
     int x;
{
      XSetForeground(d,gc,clr[16].pixel);
      XFillRectangle(d,w,gc,x*10,690,10,5);
}

int GetColor(mx,my,color)
     int mx,my;
{
      mx /= DPD;
      my /= DPD;

      if(working[my][mx] != 100)
	{
	      XSetForeground(d,gc,clr[working[my][mx]].pixel);
              XFillRectangle(d,w,gc,556,1,40,40);
              XFlush(d);
	      EraseClrCsr(color);
	      PutClrCsr(working[my][mx]);
	      return working[my][mx];
	}
}

int SetColor(mx,my,color)
     int mx,my,color;
{
      mx /= 10;
      
      if(mx < COLORNUM)
	{
	      XSetForeground(d,gc,clr[mx].pixel);
	      XFillRectangle(d,w,gc,556,1,40,40);
	      XFlush(d);
	      EraseClrCsr(color);
	      PutClrCsr(mx);
	      return mx;
	}

}

void GetChar(mx,my)
     int mx,my;
{
      int x,y;

      Clear();
      mx = (mx-330)/CSIZE;
      my = (my - 200)/CSIZE;
      
      for(y = 0 ; y < CSIZE ; y++)
	for(x = 0 ; x < CSIZE ; x++)
	  {
		working[y][x] = cbuff[my * CMAP + mx][y][x];
	  }
      
      Redraw();
}

void PutChar(mx,my)
     int mx,my;
{
      int x,y;
      
      mx = (mx-330)/CSIZE;
      my = (my - 200)/CSIZE;
      
      for(y = 0 ; y < CSIZE ; y++)
        for(x = 0 ; x < CSIZE ; x++)
          {
		cbuff[mx+CMAP*my][y][x] = working[y][x];
		if(working[y][x] != 100)
		  {
			XSetForeground(d,gc,clr[working[y][x]].pixel);
			XDrawPoint(d,w,gc,mx*CSIZE+x+330,200+my*CSIZE+y);
		  }
		else
		  {
			XSetForeground(d,gc,clr[0].pixel);
                        XDrawPoint(d,w,gc,mx*CSIZE+x+330,my*CSIZE+200+y);
		  }
	  }
}

void DrawCMap()
{
      int x,y,mx,my;
      
      for(my = 0 ; my < CMAP ; my++)
	for(mx = 0 ; mx < CMAP ; mx++)
	  {
		for(y = 0 ; y < CSIZE ; y++)
		  for(x = 0 ; x < CSIZE ; x++)
		    {			  
			  if(cbuff[mx+CMAP*my][y][x] != 100)
			    {
				  XSetForeground(d,gc,clr[cbuff[mx+CMAP*my][y][x]].pixel);
				  XDrawPoint(d,w,gc,330+mx*CSIZE+x,200+my*CSIZE+y);
			    }
			  else
			    {
				  XSetForeground(d,gc,clr[0].pixel);
				  XDrawPoint(d,w,gc,330*mx*CSIZE+x,my*CSIZE+200+y);
			    }
		    }
	  }
}

main()
{
      int color = 0;
      int event_length;
      int button_flag;
      Window r,child;
      int rx,ry;
      unsigned int mask;
      int mx,my;
      
      InitWin();
      
#ifdef _DEBUG
      fprintf(stderr,"InitWin\n");
      getchar();
#endif

      Menu();
#ifdef _DEBUG
      fprintf(stderr,"Menu\n");
      getchar();
#endif
      Clear();
#ifdef _DEBUG
      fprintf(stderr,"Clear\n");
      getchar();
#endif
      DrawPenLength(1);

      while(1)
	{
	      u_sleep(30000);

	      XQueryPointer(d,w,&r,&child,&rx,&ry,&mx,&my,&mask);
	      if(XCheckMaskEvent(d,ExposureMask,&e))
		{
		      Menu();
		      Redraw();
#ifdef _DEBUG
      fprintf(stderr,"Redraw\n");
      getchar();
#endif
		      DrawCMap();
#ifdef _DEBUG
      fprintf(stderr,"DrawCMap\n");
      getchar();
#endif
		}

	      if(mask == Button1Mask || mask == Button2Mask
		 || mask == Button3Mask)
		{
		      int i,j;
		      
		      for(i = 0 ; i< 5 ; i++)
			{
			      if(mx > xy[i][0] && mx < xy[i][2] 
				 && my > xy[i][1] && my < xy[i][3])
				break;
			}
		      
		      if(i == 5)
			continue;
		      
		      switch(i)
			{
			    case 0:
			      if(mask == Button1Mask)
				PutDot(mx,my,color);
			      
			      if(mask == Button2Mask)
				EraseDot(mx,my);

			      if(mask == Button3Mask)
				color = GetColor(mx,my,color);

			      break;
			      
			    case 2:
			      GetMenu(mx,my);
			      
			      break;
			      
			    case 1:
			      color = SetColor(mx,my,color);
			      break;
			      
			    case 3:
			      if(mask == 256)
				PutChar(mx,my);
			      
			      if(mask == 512)
				GetChar(mx,my);
			      
			      break;
			      
			    case 4:
			      GetMenu2(mx,my);
			      break;

			    default :
			      ;
			}
		}
	}
}

