/*
    SABRE Fighter Plane Simulator 
    Copyright (c) 1997 Dan Hammer
    Portions Donated By Antti Barck

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*************************************************
 *           SABRE Fighter Plane Simulator              *
 * Version: 0.1                                  *
 * File   : siminput.h                           *
 * Date   : March, 1997                          *
 * Author : Dan Hammer                           *
 * Input routines --- Linux                      *
 *************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <math.h>
#include <limits.h>
#include <values.h>
#include "defs.h"
#include "pc_keys.h"
#include "key_map.h"
#include "vmath.h"
#include "port_3d.h"
#include "sim.h"
#include "cpoly.h"
#include "obj_3d.h"
#include "copoly.h"
#include "input.h"
#include "rtkey.h"
#include "simfile.h"
#include "flight.h"
#include "flight.h"
#include "fltlite.h"
#include "weapons.h"
#include "pilot.h"
#include "zview.h"
#include "fltzview.h"
#include "unguided.h"
#include "fltmngr.h"
#include "terrain.h"
#include "kbdhit.h"
#include "siminput.h"
#include "globals.h"

extern int frame_switch;

static int switch_on_key(char c, Flight_Node &node, 
			 Flight_Manager &fm);
// Joystick buttons
#define TRIGGER_BUTTON 1
#define BUTTON_1       2
#define BUTTON_2       8
#define BUTTON_3       4
#define CH_FRWRD      15
#define CH_RIGHT      11
#define CH_BACK        7
#define CH_LEFT        3

extern void buffer2ppm();
Flight_Node *current_node;

int flight_key(Flight_Node &node, Flight_Manager &fm, 
	       FlightInput &fi, InputFile *inf)
{
  char c;
  int funct_key;
  Flight &the_flight = (Flight &) *node.flight;
  current_node = &node;
#ifndef SABREWIN
  kbhit.getch();
#endif
  if (inf != NULL)
    {
      if ((c = kbdin) != 0)
	{
	  if (c=='Q'||c=='q')
	    return 0;
	}
      if (inf->done)
	return 0;
      inf->update();
      if ((c = (char) inf->get_key()) != '\0')
	{
	  funct_key = inf->is_funct;
	  return (switch_on_key(c,node,fm));
	}
      return 1;
    }

  if ((c = kbdin) != 0)
    {
      funct_key = 0;
      if (!fi.update(the_flight,c))
	return (switch_on_key(c,node,fm));
    }
  else
    fi.update(the_flight,(char)0);
  return 1;
}

static int switch_on_key(char c, Flight_Node &node, 
			 Flight_Manager &fm)
{
  if (c=='Q'||c=='q')
    return 0;
  Flight &flt = (Flight &) *node.flight;

  switch (c)
    {
    case ')':
      extern int rz_which_line;
      rz_which_line = !rz_which_line;
      break;

    case HT:
    case '~':
      fm.set_view_node(fm.view_node + 1);
      break;

    case '*':
      //    case '9':
      if (!flt.controls.autopilot)
	flt.controls.throttle = 100;
      break;

    case '/':
    case '0':
      if (!flt.controls.autopilot)
	flt.controls.throttle = 0;
      break;


    case '+':
    case '=':
      if (!flt.controls.autopilot)
	if (flt.controls.throttle < 100)
	  flt.controls.throttle += 1.0;

      break;


    case '-':
    case '_':
      if (!flt.controls.autopilot)
	if (flt.controls.throttle > 10)
	  flt.controls.throttle -= 1.0;
      break;


    case '[':
      if (!flt.controls.autopilot)
	if (flt.controls.rudder > -30)
	  flt.controls.rudder -= 2.0;
      break;

    case ']':
      if (!flt.controls.autopilot)
	if (flt.controls.rudder < 30)
	  flt.controls.rudder += 2.0;
      break;

    case '\\':
      if (!flt.controls.autopilot)
	{
	  flt.controls.rudder = 0;
	  flt.controls.ailerons = 0;
	  flt.controls.elevators = 0;
	}
      break;

    case '>':
    case '.':
      if (!flt.controls.autopilot)
	if (flt.controls.flaps < 20)
	  flt.controls.flaps += 5;
      break;

    case '<':
    case ',':
      if (!flt.controls.autopilot)
	if (flt.controls.flaps > 0)
	  flt.controls.flaps -= 5;
      break;

    case '`':
      if (!flt.controls.autopilot)
	flt.controls.flaps = 0;
      break;

    case 'C':
    case 'c':
      flt.controls.cockpit = !flt.controls.cockpit;
      break;

    case 's':
    case 'S':
      flt.controls.hud_on = !flt.controls.hud_on;
      break;

    case 'B':
    case 'b':
      if (!flt.controls.autopilot)
	flt.controls.speed_brakes = !flt.controls.speed_brakes;
      break;

    case 'W':
    case 'w':
      if (!flt.controls.autopilot)
	flt.controls.wheel_brakes =
	  !flt.controls.wheel_brakes;
      break;

    case 'G':
    case 'g':
      if (!flt.controls.autopilot)
	flt.controls.landing_gear =
	  !flt.controls.landing_gear;
      break;

    case 'f':
      frame_switch = !frame_switch;
      break;

    case 'V':
    case 'v':
      flt.controls.vect_on = !flt.controls.vect_on;
      break;

    case 'A':
    case 'a':
      flt.controls.autopilot =
	!flt.controls.autopilot;
      break;

    case 'P':
    case 'p':
      gpause = !gpause;
      break;

    case 'X':
    case 'x':
      flt.controls.armed_w = !flt.controls.armed_w;
      break;

      /*
    case 'R':
    case 'r':
      flt.controls.radar = !flt.controls.radar;
      break;
      */

    case '1':
      flt.controls.view = front;
      break;

    case '2':
      flt.controls.view = left;
      break;

    case '3':
      flt.controls.view = right;
      break;

    case '4':
      flt.controls.view = back;
      break;

    case '5':
      flt.controls.view = satellite;
      break;

    case '6':
      flt.controls.view = outside_1;
      break;

    case '7':
      flt.controls.view = outside_2;
      break;

    case '8':
      flt.controls.view = outside_3;
      break;

    case '9':
      flt.controls.view = outside_4;
      break;

    case ';':
    case ':':
      if (!flt.controls.autopilot)
	{
	  if (flt.controls.trim < 30)
	    flt.controls.trim += 1.0;
	}
      break;

    case '\'':
    case '"':
      if (!flt.controls.autopilot)
	{
	  if (flt.controls.trim > -30)
	    flt.controls.trim -= 1.0;
	}
      break;

    case 'L':
    case 'l':
      if (!flt.controls.autopilot)
	flt.controls.trim = 0;
      break;

    case ' ':
      flt.controls.bang_bang = 1;
      break;

    case CR:
      select_next = 1;
      break;

    case '|':
      stats_on = !stats_on;
      break;

    case '}':
      track_extra = !track_extra;
      if (track_extra)
	flt.controls.radar = 1;
      break;

    case BS:
    case '^':
    case 'n':
    case 'N':
      flt.controls.bang_bang = 0;
      node.pilot->selectNextWeapon(1);
      break;

    case '{':
      flt.controls.vextern = !flt.controls.vextern;
      break;

    case '@':
      flt.controls.show_controls = !flt.controls.show_controls;
      break;


    case 'I':
    case 'i':
      if (flt.controls.vdist > 20.0)
	flt.controls.vdist -= 20.0;
      break;

    case 'U':
    case 'u':
       flt.controls.vdist += 20.0;
       break;

    case 'Y':
    case 'y':
      flt.controls.vtheta += 0.1;
      break;

    case 'Z':
    case 'z':
      flt.controls.vphi += 0.1;
      break;

    case 'M':
    case 'm':
      flt.controls.vtheta -= 0.1;
      break;

    case 'O':
    case 'o':
      flt.controls.vphi -= 0.1;
      break;
      
    case 'e':
      dump_screen = 1;
      break;

    case '%':
      display_flags ^= CLOUDS_ON;
      break;

    case '&':
      display_flags ^= TERRAIN_ON;
      break;
      
    }
  return 1;
}


FlightInput::FlightInput(Mouse *ms, Joystick *yj, Joystick *rj, Joystick *tr,
		     int mt, int mr)
{
  mouse = ms;
  y_joy = yj;
  r_joy = rj;
  t_joy = tr;
  m_throttle = mt;
  m_rudder = mr;

  throttle_device = rudder_device = yoke_device = kbd_ctrl;
      
  if (!mouse && !y_joy)
    {
      /* No mouse or joystick ... all input from keyboard */
      return;
    }
  else if (!y_joy)
    {
      /* No joystick ... use mouse for yoke, keyboard for throttle & rudder */
      yoke_device = mouse_ctrl;
      throttle_device = rudder_device = kbd_ctrl;
      return;
    }
  else
    {
      /* Use joystick for yoke */
      yoke_device = joy_ctrl;
      if (t_joy)
	{
	  /* Use 2nd joystick for throttle, and perhaps mouse for rudder */
	  throttle_device = joy_ctrl;
	  if (m_rudder)
	    rudder_device = mouse_ctrl;
	  else
	    rudder_device = kbd_ctrl;
	}
      else if (r_joy)
	{
	  /* Use 2nd joystick for rudder, and perhaps mouse for throttle */
	  rudder_device = joy_ctrl;
	  if (m_throttle)
	    throttle_device = mouse_ctrl;
	  else
	    throttle_device = kbd_ctrl;
	}
      else
	{
	  /* Perhaps use mouse for rudder, perhaps for throttle, perhaps for nothing */
	  if (m_rudder)
	    rudder_device = mouse_ctrl;
	  if (m_throttle)
	    throttle_device = mouse_ctrl;
	}
    }
}

/**********************************************
 * return true if key was used                *
 **********************************************/
int FlightInput::update(Flight &flt, char key)
{
  /* Skip if autopilot in control */
  if (flt.controls.autopilot)
    return(0);

  if (yoke_device == kbd_ctrl)
    /* Keyboard only */
    return (yoke_key(flt,key));

  if (yoke_device == mouse_ctrl)
    {
      /* Mouse only */
      yoke_mouse(flt);
      return(0);
    }

  /* Do yoke controls */
  yoke_joystick(flt);
  /* Do rudder */
  if (rudder_device == mouse_ctrl)
    rudder_mouse(flt);
  else if (rudder_device == joy_ctrl)
    rudder_joy(flt);
  /* Do throttle */
  if (throttle_device == mouse_ctrl)
    throttle_mouse(flt);
  else if (throttle_device == joy_ctrl)
    throttle_joy(flt);
  return (0);
}

/* use keys to control yoke */
int FlightInput::yoke_key(Flight &flt, char key)
{
  if (flt.controls.autopilot)
    return 0;

  int handled = 0;

  switch(key)
    {
    case DOWN:
      if (flt.controls.elevators < 30)
	flt.controls.elevators += 1.0;
      handled = 1;
      break;

    case UP:
      if (flt.controls.elevators > -30)
	flt.controls.elevators -= 1.0;
      handled = 1;
      break;

    case LEFT:
      if (flt.controls.ailerons < 30)
	flt.controls.ailerons += 2.0;
      handled = 1;
      break;

    case RIGHT:
      if (flt.controls.ailerons > -30)
	flt.controls.ailerons -= 2.0;
      handled = 1;
      break;
    }
  return handled;
}


/* Use mouse to control flight yoke */
void FlightInput::yoke_mouse(Flight &flt)
{
  float e,a;
  float m_x,m_y;

  m_x = mouse->GetX();
  m_x = -m_x;
  m_y = mouse->GetY();
  e = (m_y * 30.0);
  a = (m_x * 30.0);
  flt.controls.ailerons = a;
  if (e + flt.controls.trim > 30)
    e = 30 - flt.controls.trim;
  if (e + flt.controls.trim < -30)
    e = -30 - flt.controls.trim;
  flt.controls.elevators = e;
  if (mouse->GetButtons())
    flt.controls.bang_bang = 1;
}

/* Use mouse to control throttle & brakes */
void FlightInput::throttle_mouse(Flight &flt)
{
  float m_y;
  // 0 <= m_y <= 1
  m_y = -mouse->GetY();
  if (m_y < 0.0)
    m_y = 0.0;
  flt.controls.throttle =  (m_y * 100.0);
  if (mouse->GetButtons())
    flt.controls.speed_brakes = !flt.controls.speed_brakes;
}

/* use mouse to control rudder */
void FlightInput::rudder_mouse(Flight &flt)
{
  float m_x;
  // -1 <= m_x <= 1
  m_x = mouse->GetX();
  flt.controls.rudder = (m_x * 30.0);
}

/* use joystick to control rudder */
void FlightInput::rudder_joy(Flight &flt)
{
  float m_x;
  m_x = r_joy->GetY();
  flt.controls.rudder = (m_x * 30.0);
}

/* use joystick to control throttle */
void FlightInput::throttle_joy(Flight &flt)
{
  float m_y;
  // -1 <= m_y <= 1
  m_y = t_joy->GetY();
  flt.controls.throttle = 50 - (m_y * 100.0);
}

/* use joystick to control yoke */
void FlightInput::yoke_joystick(Flight &flt)
{
  float m_x,m_y;
  float e,a;

  m_x = y_joy->GetX();
  m_x = -m_x;
  m_y = y_joy->GetY();
  e = (int) (m_y * 30.0);
  a = (int) (m_x * 30.0);
  flt.controls.ailerons = a;
  if (e + flt.controls.trim > 30)
    e = 30 - flt.controls.trim;
  if (e + flt.controls.trim < -30)
    e = -30 - flt.controls.trim;
  flt.controls.elevators = e;
  int bt = y_joy->GetButtons();
  if (bt)
    do_joystick_button(bt,flt);
}

/* interpret joystick button */
void FlightInput::do_joystick_button(int bt, Flight &flt)
{
  switch ((int) bt)
    {
    case TRIGGER_BUTTON:
      flt.controls.bang_bang = 1;
      break;

    case BUTTON_2:
      flt.controls.armed_w = !flt.controls.armed_w;
      break;

    case BUTTON_1:
      if (throttle_device == mouse_ctrl)
	{
	  flt.controls.bang_bang = 0;
	  current_node->pilot->selectNextWeapon(1);
	}
      else
	flt.controls.speed_brakes = !flt.controls.speed_brakes;
      break;

    case BUTTON_3:
      flt.controls.view = outside_2;
      break;

    case CH_FRWRD:
      flt.controls.view = front;
      break;

    case CH_RIGHT:
      flt.controls.view = right;
      break;

    case CH_BACK:
      flt.controls.view = back;
      break;

    case CH_LEFT:
      flt.controls.view = left;
      break;
    }
}

InputFile::InputFile(char *f_source)
{
  input_file = fopen(f_source,"r");
  MYCHECK(input_file != NULL);
  done = 0;
  read();
}

InputFile::~InputFile()
{
  fclose(input_file);
}

int InputFile::get_key()
{
  int result = key;
  rpt_count--;
  if (rpt_count <= 0)
    key = 0;
  return result;
}

void InputFile::update()
{
  elapsed_time += time_frame;
  if (elapsed_time >= time_limit)
    read();
}

void InputFile::read()
{
  char buff[80];
  elapsed_time = 0.0;
  time_limit = 0.0;
  int n = 0;
  rpt_count = 1;
  while (!done)
    {
      if (!fgets(buff,sizeof(buff),input_file))
	{
	  done = 1;
	  break;
	}
      * (buff + (strlen(buff) - 1 )) = '\0';
      if (*buff == '*')
	continue;
      else switch (n)
	{
	case 0:
	  key = kmp_str(buff,is_funct);
	  if (!key)
	    {
	      key = *buff;
	      is_funct = 0;
	    }
	  n++;
	  break;

	case 1:
	  time_limit = atof(buff);
	  if (time_limit < 0.0)
	    time_limit = 0.0;
	  n++;
	  break;

	case 2:
	  if (*buff == '#')
	    rpt_count = atoi(buff+1);
	  else if ((strlen(buff) > 0) && (*buff != ' '))
	    {
	      buff[31] = '\0';
	      strcpy(message_buff,buff);
	    }
	  n++;
	  break;
	}
      if (n > 2)
	break;
    }
}
