/*
    SABRE Fighter Plane Simulator 
    Copyright (c) 1997 Dan Hammer
    Portions Donated By Antti Barck

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*************************************************
 *           SABRE Fighter Plane Simulator              *
 * Version: 0.1                                  *
 * File   : hud.C                                *
 * Date   : March, 1997                          *
 * Author : Dan Hammer                           *
 *************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <values.h>
#include <string.h>
#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include "defs.h"
#include "pc_keys.h"
#include "grafix.h"
#include "vga_13.h"
#include "traveler.h"
#include "pen.h"
#include "convpoly.h"
#include "vmath.h"
#include "port_3d.h"
#include "cpoly.h"
#include "copoly.h"
#include "font8x8.h"
#include "flight.h"
#include "fltlite.h"
#include "weapons.h"
#include "unguided.h"
#include "bits.h"
#include "zview.h"
#include "fltzview.h"
#include "simfile.h"
#include "pilot.h"
#include "fltmngr.h"
#include "rtkey.h"
#include "sim.h"
#include "input.h"
#include "globals.h"
#include "siminput.h"
#include "colorspc.h"
#include "earth.h"
#include "hud.h"

extern float raw_time;

void Hud::read_file(char *path)
{
  ifstream is;
  if (open_is(is,path))
    is >> *this;
}

istream &operator >>(istream &is, Hud &hd)
{
  char c = ' ';

  READ_TOK('{',is,c);
  color_spec cs,cs1,cs2,cs3,cs4,cs5;
  is >> cs >> cs1 >> cs2 >> cs3 >> cs4 >> cs5;
  hd.hud_color = cs.color;
  hd.vector_color = cs1.color;
  hd.gunsight_color1 = cs2.color;
  hd.gunsight_color2 = cs3.color;
  hd.look_at_color = cs4.color;
  hd.target_color = cs5.color;
  is >> hd.flt1_x >> hd.flt1_y;
  is >> hd.flt2_x >> hd.flt2_y;
  is >> hd.flt3_x >> hd.flt3_y;
  is >> hd.flt4_x >> hd.flt4_y;
  is >> hd.gns_x >> hd.gns_y;
  is >> hd.trg_x >> hd.trg_y;
  READ_TOK('}',is,c);
  return is;
}

void Hud::do_hud(Flight_Node &my_node)
{
  R_KEY_BEGIN(1000) // void do_hud(Flight_Node &)
  int x1,y1,x2,y2;
  int x,y;
  REAL_TYPE ground_level;
  Flight & my_flight = *(my_node.flight);
  Port_3D *port = &my_flight.state.flight_port;
  float d1,d2,alt;


  Pilot *pilot = my_node.pilot;
  ground_level = my_flight.state.ground_height / world_scale;
  alt = port->look_from.z / world_scale;

  // altitude, speed, load
  the_font->font_sprintf(1,1,hud_color,NORMAL,
			 " %07.2f KTS", (my_flight.state.z_vel * 3600.0 ) / 6000.0);
  the_font->font_sprintf(1,8,hud_color,NORMAL,
			 "%08.2f", my_flight.state.agl / world_scale);
  the_font->font_sprintf(1,16,hud_color,NORMAL,
			 "%08.2f %1.1f",
			 alt,
			 my_flight.state.load);

  /*
  the_font->font_sprintf(1,24,hud_color,NORMAL,
			 "roll_acc: %08.3f  roll_rate: %08.3f",
			 my_flight.forces.roll_acc,
			 my_flight.state.roll_rate);
			 */

  // throttle settings & indicators
  do_hud_stuff(SCREEN_WIDTH-(15*6),1,my_flight);

  // additional flight info
  the_font->font_sprintf(SCREEN_WIDTH-(8*6),8,hud_color,NORMAL,
			 "%08.1f",
			 my_flight.state.climb_vel * 60.0);
  the_font->font_sprintf(SCREEN_WIDTH-(5*6),16,hud_color,NORMAL,
			 "%5.1f",
			 57.29578 * my_flight.state.heading);
  // combat info
  d1 = ((float) my_flight.mods.battle_damage) / ((float) my_flight.specs->max_damage) * 100.0;
  gns_x = 1;
  gns_y = SCREEN_HEIGHT-8;

  if (stats_on)
    {
      if (raw_time > 0.0)
	d2 = 1.0 / raw_time;
      else
	d2 = 0.0;
      the_font->font_sprintf(gns_x,gns_y,hud_color,NORMAL,
			     "%3.0f%% %d %3.1f",
			     d1,
			     pilot->sel_weapon->rounds_remaining,
			     d2);
    }
  else
    {
      char *cc;
      char *pp;
      if (my_flight.controls.autopilot)
	pp = pilot->dbg;
      else
	pp = "";
      if (!my_flight.state.on_ground && my_flight.state.near_stall < 0.005)
	{
	  if (my_flight.state.stalled)
	    cc = "*STALL*";
	  else
	    cc = "STALL";
	}
      else
	cc = "";
      if (my_flight.controls.armed_w)
	the_font->font_sprintf(gns_x,gns_y,hud_color,NORMAL,
			       "%s %s%3.0f%% %s %d",
			       pp,
			       cc,
			       d1,
			       pilot->sel_weapon->weapon->w_specs->wep_name,
			       pilot->sel_weapon->rounds_remaining
			       );
      else
	the_font->font_sprintf(gns_x,gns_y,hud_color,NORMAL,
			       "%s %s%3.0f%%",
			       pp,
			       cc,
			       d1
			       );
    }

  if (pilot->target != NULL || pilot->waypoint != NULL)
    {
      R_3DPoint *pt;
      float *sc_x,*sc_y;
      if (pilot->target != NULL && pilot->target_flight)
	{
	  if (my_flight.controls.radar
	      && (my_flight.specs->flags & RADAR_TYPE_MASK)
	      && (pilot->trk.p_position.z > 0.0)
	      && (pilot->trk.sc_x <= 300)
	      && (pilot->trk.sc_y <= 300)
	      )
	    do_hud_target_geometry(trg_x,trg_y,*pilot);
	  pt = & pilot->trk.p_position;
	  sc_x = & pilot->trk.sc_x;
	  sc_y = & pilot->trk.sc_y;
	}
      else
	{
	  pt = & pilot->wp_trk.p_position;
	  sc_x = & pilot->wp_trk.sc_x;
	  sc_y = & pilot->wp_trk.sc_y;
	}

      if (pt->z > 0)
	{
	  x = ((int) *sc_x) + ((int)port->cx);
	  y = (- (int) *sc_y) + ((int)port->cy);
	}
      else
	{
	  if (pt->x < 0)
	    x = port->screen.topLeft.x;
	  else
	    x = port->screen.botRight.x;
	  if (pt->y < 0)
	    y = port->screen.botRight.y;
	  else
	    y = port->screen.topLeft.y;
	}
      x1 = x;
      if (x1 < port->screen.topLeft.x)
	x1 = port->screen.topLeft.x;
      else if (x1 > port->screen.botRight.x)
	x1 = port->screen.botRight.x;
      x2 = x1;
      y1 = 0;
      y2 = 5;
      b_linedraw(x1,y1,x2,y2,hud_color,&port->screen);
      y1 = y;
      if (y1 < port->screen.topLeft.y)
	y1 = port->screen.topLeft.y;
      else if (y1 > port->screen.botRight.y)
	y1 = port->screen.botRight.y;
      y2 = y1;
      x1 = 0;
      x2 = 5;
      b_linedraw(x1,y1,x2,y2,hud_color,&port->screen);
    }

  // Finally, show control positions
  if (my_flight.controls.show_controls)
    show_controls(my_flight,*port);
  R_KEY_END
    }

void Hud::do_hud_target_geometry(int x, int y, Pilot &pilot)
{
  char range_str[32];

  y = SCREEN_HEIGHT - 28;
  x = SCREEN_WIDTH - 7 * 6;

  if (pilot.target_flight)
    {
      if (pilot.tg.range > 3000.0)
	sprintf(range_str," %05.1f",pilot.tg.range / 6000.0);
      else
	sprintf(range_str," %05.2f",pilot.tg.range);
      the_font->font_sprintf(x,y,hud_color,NORMAL,
			     "%06.2f",
			     pilot.tg.angle_off / _PI * 180);
      the_font->font_sprintf(x,y+7,hud_color,NORMAL,
			     "%06.2f%c",
			     pilot.tg.aspect / _PI * 180,
			     pilot.tg.l_r);
      
      the_font->font_sprintf(x,y+14,hud_color,NORMAL,
			     "%s",
			     range_str);
      the_font->font_sprintf(x,y+21,hud_color,NORMAL,
			     "%5.2f",
			     pilot.tg.d_range);
    }
}

void Hud::do_hud_stuff(int x, int y, Flight &my_flight)
{
  if (my_flight.controls.autopilot)
    hud_stuff[0] = 'A';
  else
    hud_stuff[0] = ' ';
  if (my_flight.controls.landing_gear)
    hud_stuff[1] = 'G';
  else
    hud_stuff[1] = ' ';
  if (my_flight.controls.wheel_brakes)
    hud_stuff[2] = 'W';
  else
    hud_stuff[2] = ' ';
  if (my_flight.controls.speed_brakes)
    hud_stuff[3] = 'B';
  else
    hud_stuff[3] = ' ';
  if (my_flight.controls.flaps)
    {
      hud_stuff[4] = 'F';
      the_font->font_sprintf(x,y,hud_color,NORMAL,"%s %02d %03.0f%%",hud_stuff,
			     my_flight.controls.flaps,
			     my_flight.controls.throttle);
    }
  else
    {
      hud_stuff[4] = ' ';
      the_font->font_sprintf(x,y,hud_color,NORMAL,"%s    %03.0f%%",hud_stuff,
			     my_flight.controls.throttle);
    }
}

#define NOSE_CHAR 128
#define YOKE_CHAR (unsigned char) 136
#define RUDDER_CENTER_CHAR (unsigned char) 139
#define RUDDER_CHAR (unsigned char) 140

void Hud::show_controls(Flight &my_flight, Port_3D &port)
{
  int x1,y1;
  int x2,y2;

  port.transform(my_flight.state.flight_port.look_at,&x1,&y1);
  if (!my_flight.controls.armed_w)
    the_font->put_char(NOSE_CHAR,x1-3,y1-4,look_at_color,8);
  
  x2 = x1 - ((int) my_flight.controls.ailerons);
  y2 = y1 + ((int) my_flight.controls.elevators);
  the_font->put_char(YOKE_CHAR,x2-3,y2-4,look_at_color,8);
  the_font->put_char(RUDDER_CENTER_CHAR,x1-3,SCREEN_HEIGHT-3,hud_color,8);
  x2 = x1 + ((int) my_flight.controls.rudder);
  the_font->put_char(RUDDER_CHAR,x2-3,SCREEN_HEIGHT-11,hud_color,8);
}

void Hud::show_vector(Flight &my_flight, Port_3D &port)
{
  int x1,y1;
  R_3DPoint lf;
  R_3DPoint vr;
  Port_3D *fport = &my_flight.state.flight_port;
  if (my_flight.state.velocity.magnitude > 0
      && !my_flight.controls.armed_w)
    {
      DVector v = to_vector(my_flight.state.velocity);
      vr = R_3DPoint(v.to_vector());
      lf = fport->look_from + vr;
      port.transform(lf,&x1,&y1);
      if (!port.over_flow)
	the_font->put_char((unsigned char)129,
			   x1-3,y1-4,vector_color,
			   8);
    }
}

void Hud::show_waypoint(Pilot *p, Port_3D &port)
{
  R_3DPoint p0;
  int x,y;
  WayPoint *wp = p->waypoint;
  if (wp == NULL)
    return;
  port.world2port(wp->location,&p0);
  if (p0.z >= 200.0 * world_scale)
    {
      port.port2screen(p0,&x,&y);
      if (!port.over_flow && port.IsVisible(x,y))
	the_font->put_char((unsigned char)135,
			   x-3,y-4,hud_color,8);
      /*
      port.world2port(p->wp_trk.al_w,&p0);
      port.port2screen(p0,&x,&y);
      if (!port.over_flow && port.IsVisible(x,y))
	the_font->put_char((unsigned char)134,
			   x-3,y-4,hud_color,8);
      x = p->wp_trk.al_scx + port.cx;
      y = -p->wp_trk.al_scy + port.cy;
      if (port.IsVisible(x,y))
	the_font->put_char((unsigned char)134,
			   x-3,y-4,hud_color,8);
			   */
    }
}

void Hud::show_selected_target(Flight_Node &my_node, Port_3D &port)
{
  R_KEY_BEGIN(1002) // void show_selected_target(Flight_Node ...)
    Pilot *pilot = my_node.pilot;
  Flight *flight = my_node.flight;

    if (pilot->target && flight->controls.radar)
      {
	R_3DPoint *w,p;
	int x1,y1;
	int x0,y0;
	unsigned char c;
	if (flight->controls.view == front)
	  {
	    if (pilot->in_range)
	      w = & pilot->g_trk.w_position;
	    else
	      w = & pilot->l_trk.w_position;
	    if (pilot->in_range)
	      c = 127;
	    else
	      c = 133;
	  }
	else if (flight->controls.view <= outside_2)
	  {
	    w = & pilot->trk.w_position;
	    c = 133;
	  }
	else
	  {
	    w = & flight->state.flight_port.look_from;
	    c = 133;
	  }
	port.world2port(*w,&p);
	port.port2screen(p,&x1,&y1);
	if (!port.over_flow && y1 >= 0 && y1 <= SCREEN_HEIGHT - 1 &&
	    x1 >= 0 && x1 <= SCREEN_WIDTH - 1)
	  {
	    the_font->put_char(c,x1-4,y1-4,hud_color,8);
	    /*
	    port.transform(pilot->tg.bp,&x0,&y0);
	    the_font->put_char(133,x0-4,y0-4,hud_color-1,8);
	    */
	    port.transform(pilot->trk.w_position,&x0,&y0);
	    port.transform(pilot->l_trk.w_position,&x1,&y1);
	    b_linedraw(x0,y0,x1,y1,hud_color,&port.screen);
	  }

      }
  R_KEY_END
    }

void Hud::show_gunsight(Flight_Node &my_node, Port_3D &port)
{
  R_KEY_BEGIN(1003) // void show_gunsight
    int x2,y2;
  R_3DPoint p1;
  Pilot &pilot = *my_node.pilot;
  if (pilot.sel_weapon && my_node.flight->controls.armed_w)
    {
      if (
	  pilot.target
	  && my_node.flight->controls.radar
	  && (my_node.flight->specs->flags & RADAR_TYPE_MASK)
	  && (pilot.trk.sc_x <= 100 * Pilot::xpixel_adjust)
	  && (pilot.trk.sc_y <= 100 * Pilot::ypixel_adjust)
	  )
	show_selected_target(my_node,port);

      int wpt = WPSPECS(pilot.sel_weapon)->wep_type;
      
      switch (wpt)
	{

	case gun_t:
	  port.world2port(pilot.gun_point,&p1);
	  break;
	  
	default:
	  p1.y = p1.x = 0.0;
	  p1.z = 1.0;
	  break;

	}

      port.port2screen(p1,&x2,&y2);
      //     if (y2 >= 10 && y2 <= 180 && x2 >= 10 && x2 <= 310)
	the_font->put_char((unsigned char)130,x2-3,y2-4,
			   hud_color,8);
    }
  R_KEY_END
    }


