/* Risk! for Linux..
 * toolbar.c
 *
 * Copyright (C) 1998 Joel Nordell
 *
 * This file is protected under the GPL license.
 */

#include "toolbar.h"
#include "newgame.h"

GtkWidget *StatusLabel = NULL;  // The label for the Status Bar widget...
GtkWidget *CountryLabel = NULL; // The label for the Country Status bar...
#ifdef COORDS_STATUS_BAR
GtkWidget *CoordsLabel = NULL;  // The label for the Coords Status Bar...
#endif

GtkWidget *toolbar_create() {
  GtkWidget *tearoff;
  GtkWidget *toolbar;
  GtkWidget *button;

  tearoff = gtk_handle_box_new();
  gtk_widget_show(tearoff);

  toolbar = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(toolbar);
  gtk_widget_set_usize(toolbar, 630, 0);

  gtk_container_add(GTK_CONTAINER(tearoff), toolbar);

  button = gtk_button_new_with_label("New Game");
  gtk_widget_show(button);
  gtk_widget_set_usize(button, 64, 0);
  gtk_signal_connect(GTK_OBJECT(button), "clicked",
                    (GtkSignalFunc)new_game_cmd_callback, NULL);
  gtk_container_add(GTK_CONTAINER(toolbar), button);

  button = gtk_button_new_with_label("Button 2");
  gtk_widget_show(button);
  gtk_widget_set_usize(button, 64, 0);
  gtk_container_add(GTK_CONTAINER(toolbar), button);

  button = gtk_button_new_with_label("Button 3");
  gtk_widget_show(button);
  gtk_widget_set_usize(button, 64, 0);
  gtk_container_add(GTK_CONTAINER(toolbar), button);

  return tearoff;
}

GtkWidget *statusbar_create() {
  GtkWidget *statusbar;
  GtkWidget *statusframe;

  statusbar = gtk_hbox_new(FALSE, 0);
  gtk_widget_show(statusbar);
  gtk_widget_set_usize(statusbar, 640, 0);

  /****** STATUSBAR LABEL ******/
  statusframe = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(statusframe), GTK_SHADOW_IN);
  gtk_widget_show(statusframe);
  gtk_widget_set_usize(statusframe, 
                       640-130
#ifdef COORDS_STATUS_BAR
-70
#endif
                       , 0);
  gtk_container_add(GTK_CONTAINER(statusbar), statusframe);

  StatusLabel = gtk_label_new("");
  gtk_widget_set_usize(StatusLabel,
                       630-130
#ifdef COORDS_STATUS_BAR
-70
#endif
                       , 0);
  gtk_label_set_justify(GTK_LABEL(StatusLabel), GTK_JUSTIFY_LEFT);
  gtk_widget_show(StatusLabel);
  gtk_container_add(GTK_CONTAINER(statusframe), StatusLabel);

  /****** COUNTRY LABEL ******/
  statusframe = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(statusframe), GTK_SHADOW_IN);
  gtk_widget_set_usize(statusframe, 130, 0);
  gtk_widget_show(statusframe);
  gtk_container_add(GTK_CONTAINER(statusbar), statusframe);

  CountryLabel = gtk_label_new("");
  gtk_label_set_justify(GTK_LABEL(CountryLabel), GTK_JUSTIFY_LEFT);
  gtk_widget_set_usize(CountryLabel, 120, 0);
  gtk_widget_show(CountryLabel);
  gtk_container_add(GTK_CONTAINER(statusframe), CountryLabel);

#ifdef COORDS_STATUS_BAR
  /****** COORDS LABEL ******/
  statusframe = gtk_frame_new(NULL);
  gtk_frame_set_shadow_type(GTK_FRAME(statusframe), GTK_SHADOW_IN);
  gtk_widget_set_usize(statusframe, 70, 0);
  gtk_widget_show(statusframe);
  gtk_container_add(GTK_CONTAINER(statusbar), statusframe);

  CoordsLabel = gtk_label_new("");
  gtk_widget_show(CoordsLabel);
  gtk_container_add(GTK_CONTAINER(statusframe), CoordsLabel);
#endif

  return statusbar;
}

void set_status(char *new_label) {
  char *old_label;

  gtk_label_get(GTK_LABEL(StatusLabel), &old_label);

  // Only change label if new one is DIFFERENT..
  if (strcmp(new_label, old_label))
    gtk_label_set(GTK_LABEL(StatusLabel), new_label);
}

void set_country_status(char *new_label) {
  char *old_label;

  gtk_label_get(GTK_LABEL(CountryLabel), &old_label);

  // Only change label if new one is DIFFERENT..
  if (strcmp(new_label, old_label)) {
    gtk_label_set(GTK_LABEL(CountryLabel), new_label);
  }
}

void set_coords(int x, int y) {
#ifdef COORDS_STATUS_BAR
  char new_label[25];

  sprintf(new_label, "(%d, %d)", x, y);

  gtk_label_set(GTK_LABEL(CoordsLabel), new_label);
#else
  return;
#endif
}

