/* Risk! for Linux..
 * main.c
 *
 * Copyright (C) 1998 Joel Nordell
 *
 * This file is protected under the GPL license.
 */

#include <gtk/gtk.h>
#include "board.h"
#include "main.h"
#include "menus.h"
#include "toolbar.h"
#include "board_xpm.h"

GtkWidget *MainWindow = NULL;

void about_box_cmd_callback(GtkWidget *widget, gpointer data) {
/*
  GtkWidget *window;
  GtkWidget *button;
  GtkWidget *fixed;
  GtkWidget *pixmap;

  window = gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_title(GTK_WINDOW(window), "About Global Conquest");
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);

  pixmap = gtk_pixmap_new(TitlePixmap, NULL);
  gtk_widget_show(pixmap);

  button = gtk_button_new_with_label("OK");
  gtk_widget_set_usize(button, 64, 0);
  gtk_widget_show(button);

  fixed = gtk_fixed_new();
  gtk_widget_show(fixed);
  gtk_container_add(GTK_CONTAINER(window), fixed);

  gtk_fixed_put(GTK_FIXED(fixed), pixmap, 0, 0);
  gtk_fixed_put(GTK_FIXED(fixed), button, 246, 158);

  gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                            GTK_SIGNAL_FUNC(gtk_widget_destroy),
                            GTK_OBJECT(window));

  gtk_widget_grab_focus(button);
  gtk_widget_show(window);
*/
}

void setup_main_window() {
}

void establish_window(char *cmd) {
  GtkWidget *StatusBar;
  GtkWidget *label;
  FILE *intro;
  GtkWidget *window;
  GtkWidget *box;
  GtkWidget *board;
  GtkWidget *menubar;
  GtkWidget *statusbar;
  GtkAcceleratorTable *accel;
  GtkWidget *tearoff;
  char introprog[1000];

  // Open a pipe to the intro thingie
  strcat(cmd, "_intro");
  intro = popen(cmd, "w");

  // Start setting up the stuff
  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  gtk_widget_realize(window);

  gtk_window_set_title(GTK_WINDOW(window), "Global Conquest");
  gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);

  gtk_signal_connect (GTK_OBJECT(window), "delete_event",
                      GTK_SIGNAL_FUNC(gtk_exit), NULL);
  gtk_container_border_width(GTK_CONTAINER(window), 0);
  
  box = gtk_vbox_new(FALSE, 0);
  gtk_widget_show(box);

  get_main_menu(&menubar, &accel);
  gtk_widget_set_usize(menubar, 630, 24);
  gtk_container_border_width(GTK_CONTAINER(menubar), 0);
  gtk_container_disable_resize(GTK_CONTAINER(menubar));

  tearoff = gtk_handle_box_new();
  gtk_container_disable_resize(GTK_CONTAINER(tearoff));
  gtk_widget_show(tearoff);
  gtk_container_add(GTK_CONTAINER(tearoff), menubar);

  gtk_window_add_accelerator_table(GTK_WINDOW(window), accel);
  gtk_widget_show(menubar);

  board = board_new(window);

  gtk_box_pack_start(GTK_BOX(box), tearoff, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(box), toolbar_create(), FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(box), board, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(box), statusbar_create(), FALSE, FALSE, 0);
  gtk_container_add(GTK_CONTAINER(window), box);
  gtk_widget_show(board);

  MainWindow = window;

  // Send a signal to the title window process to close itself
  fprintf(intro, "\n");
  pclose(intro);
  
  // Finally show the main window
  gtk_widget_show(MainWindow);
}

main(int argc, char **argv) {
  char gtkrc[100];
  char progname[255];

  if (getenv("HOME") != NULL) {
    sprintf(gtkrc, "%s/.gtkrc", getenv("HOME"));
  } else sprintf(gtkrc, "/etc/system.gtkrc");

  strncpy(progname, argv[0], 254);

  gtk_init (&argc, &argv);
  gtk_rc_parse (gtkrc);
  establish_window(progname);
  gtk_main();
}

void file_quit_cmd_callback (GtkWidget *widget, gpointer data)
{
  g_print("%s\n", (char *)data);
  gtk_exit(0);
}
