#!/usr/bin/env python

#    Copyright (C) 1998 Kevin O'Connor
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys
import os
import select
import string
import socket
# Readline is not practical because there is no way to interleave terminal
# input and socket input using the current Python implementation of readline.
#import readline

import empDb
import empQueue
import empCmd

# Key Ideas:

# What is contained within this file:

# This file contains the code necessary to "bootstrap" the other code
# files.  The code in this file has been left intentionally sparse because
# this file is often translated to byte-code multiple times.  The only real
# code is the simple text viewer interface.  The text viewer is a fall back
# for the graphical interface.  The text interface is designed for
# compatibility of the Tk interface, not vice-versa.  Please see the
# documentation of empQueue.py for information on the structure of the
# viewer class.

# The use of global variables throughout this project:

# In general, I dislike the use of global variables.  There are only three
# uses of global variables.  (However, there are a number of global
# constants.)  The main two occurrences are the global viewer class, and
# the empDb.megaDB global database.  The viewer class is established in
# this file.  The main database is established with a call to
# empDb.loadFile().  Although I dislike global variables, I felt it
# necessary to use them in these circumstances.  Under normal conditions,
# almost all classes and functions would require both viewer and megaDB.
# It makes little sense to pass these variables with nearly every single
# call.  Also, that many references to the same variable is bound to cause
# some form of circular referencing, which is not a good idea(tm) in
# Python.  (The third usage of a global variable is empQueue defined within
# empQueue.py.  This is a minor usage that I may just edit out in the
# future..)

###########################################################################
#############################  Text interface #############################
class SText:
    """Simple ASCII Text interface"""

    def __init__(self):
	self.loginCallback = self
	self.stayOnline = 1
	self.atPrompt = 0

    def data(self, msg):
	"""empQueue handler: called with each line of data received
	from the server."""
	print msg
	self.atPrompt = 0

    def flush(self, msg):
	"""empQueue handler: called when a subprompt is encountered."""
	try:
	    cmd = raw_input(msg)
	except KeyboardInterrupt:
	    cmd = "ctlc"
	    print
	self.ioq.SendNow(cmd)
	self.atPrompt = 0

    def End(self, cmd):
	"""empQueue handler: called at the end of each command."""#
#	if len(self.ioq.queue.FuncList) > 1:
##	    return
	if self.atPrompt:
	    print
	print empDb.GetPrompt(),
	sys.stdout.flush()
	self.atPrompt = 1

    def Begin(self, cmd):
	"""empQueue handler: called at the beginning of each command."""
	if self.atPrompt:
	    sys.stdout.write("")
	    print "[[%s]]" % cmd
	    self.atPrompt = 0

    Answer = updateDB = empQueue.doNothing

    def inform(self):
	"""empQueue handler: called when there is an async prompt update."""
	if self.atPrompt:
	    sys.stdout.write("")
	    print "\n"+empDb.GetPrompt(),
	    sys.stdout.flush()

    def flash(self, msg):
	"""empQueue handler: called when an async line of data is received."""
	if self.atPrompt:
	    sys.stdout.write("")
	    print
	    self.atPrompt = 0
	print msg

    def connect_terminate(self):
	"""Login handler: Called when the server disconnects"""
	self.stayOnline = 0

    def login_error(self, msg):
	"""Login handler: Called when a login error occurs"""
	print msg
	# HACK! See if we are online..
	if self.ioq.sock.flags >= empQueue.QU_DISCONNECT:
	    ldb = empDb.megaDB['login']
	    t = raw_input("host[%s]: " % ldb['host'])
	    if t:
		ldb['host'] = t
	    while 1:
		t = raw_input("port[%s]: " % ldb['port'])
		if t:
		    try: t = string.atoi(t)
		    except ValueError:
			continue
		    ldb['port'] = t
		break
	# Hack! Check if we need to kill
	if msg[:22] == "[3] country in use by ":
	    t = raw_input("Try to issue a kill? [n] ")
	    if t[:1] == 'y' or t[:1] == 'Y':
		self.login_kill = 1
		self.loginHandler.retry()
		return
	ldb = empDb.megaDB['login']
	t = raw_input("Country? [%s] " % ldb['coun'])
	if t:
	    ldb['coun'] = t
	t = raw_input("Representative? [%s] " % ldb['repr'])
	if t:
	    ldb['repr'] = t
	self.loginHandler.retry()

    def login_success(self):
	"""Login handler: Called upon a successful login"""
	pass

    login_kill = 0

##     def tryLogin(self):
## 	ldict = empDb.megaDB['login']
## 	self.login_kill = 0
## 	self.login_host = ldict['host']
## 	self.login_port = ldict['port']
## 	self.login_coun = ldict['coun']
## 	self.login_repr = ldict['repr']

## 	# Verify visitor account with graphical window
## 	if self.login_coun == "visitor":
## 	    t = raw_input('host[%s]: ' % self.login_host)
## 	    if t: self.login_host = ldict['host'] = t
## 	    t = raw_input('port[%s]: ' % self.login_port)
## 	    if t: self.login_port = ldict['port'] = t
## 	    t = raw_input('Country? [%s] ' % self.login_coun)
## 	    if t: self.login_coun = ldict['coun'] = t
## 	    t = raw_input('Representative? [%s] ' % self.login_repr)
## 	    if t: self.login_repr = ldict['repr'] = t

## 	while 1:
## 	    try: self.loginHandler = viewer.ioq.sock.Connect(self)
## 	    except socket.error, e:
## 		print "Connect error: " + str(e)
## 	    else:
## 		break
## 	    t = raw_input('host[%s]: ' % self.login_host)
## 	    if t: self.login_host = ldict['host'] = t
## 	    t = raw_input('port[%s]: ' % self.login_port)
## 	    if t: self.login_port = ldict['port'] = t

##     def login_error(self, msg=None):
## 	ldict = empDb.megaDB['login']
## 	print "Login error: " + msg
## 	t = raw_input('Country? [%s] ' % self.login_coun)
## 	if t: self.login_coun = ldict['coun'] = t
## 	t = raw_input('Representative? [%s] ' % self.login_repr)
## 	if t: self.login_repr = ldict['repr'] = t
## 	self.loginHandler.retry()

    def connect_success(self):
	"""Login handler: Called when the server connects"""
	self.ioq.Send("exec connect.emp")

    def main(self):
	"""Main data retrival loop."""
	while self.stayOnline:
	    pending = select.select([self.ioq, sys.stdin], [], [])[0]
	    if pending and pending[0] == self.ioq:
		self.ioq.HandleInput()
		del pending[0]
	    if pending and pending[0] == sys.stdin:
		try:
		    cmd = raw_input()
		except EOFError:
		    cmd = "ctld"
		    print
		if self.atPrompt:
		    sys.stdout.write("")
		    self.atPrompt = 0
		self.ioq.Send(cmd)
		del pending[0]

###########################################################################
#############################  Startup	      #############################

# Some defaults..
if len(sys.argv) > 1:
    FILE = sys.argv[1]
else: FILE = "EmpDB"
first = empDb.loadDB(FILE)
del FILE

# Attempt to load Tk viewer.  If that fails use text interface.
try:
    import empTk
except ImportError:
    print "Unable to start graphical display - reverting to text interface."
    viewer = SText()
else:
    viewer = empTk.mainWin()

# Set some common defaults among all the interfaces.
empDb.viewer = empCmd.viewer = empQueue.viewer = viewer

# Attempt to find the username.
try: USERNAME = os.environ['USER']
except (AttributeError, KeyError):
    USERNAME = 'PythonTk'

# Set everything up
sockQueue = empQueue.EmpData(USERNAME, first)
del USERNAME
cmdParser = empCmd.EmpParse(sockQueue)
viewer.ioq = cmdParser

# run the initialization script
if first:
    cmdParser.Send("exec first.emp")
del first

# Start boot-up script
cmdParser.Send("exec start.emp")

## # Force connect
## sockQueue.loginParser.Connect()

# Go!
viewer.main()
