"""Permits host/port and country/representative information to be entered
in graphically."""

#    Copyright (C) 1998 Kevin O'Connor
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from Tkinter import *
import string

import empDb
import empQueue

###########################################################################
#############################  Login window   #############################
class loginWin:
    """Get host/port and coun/rep info in a graphical manner."""
    def __init__(self):
	self.ldict = empDb.megaDB['login']
	self.login_kill = 0

	# Create root window
	self.Root = Toplevel(name='login')
	self.Root.withdraw()
	self.Root.title("Empire login")
	self.Root.iconname("Empire login")
	self.Root.bind('<Return>', self.DoPlay)
	self.Root.protocol('WM_DELETE_WINDOW', self.handleDelete)

	self.Status = Label(self.Root, name='status', width=40, anchor=W,
			    text="hrmm")
	self.Status.pack(side=BOTTOM, fill=X, expand=1)

	# Create network info section.
	lhost = Label(self.Root, name='lhost', anchor=W, text='Host:')
	lhost.pack(fill=X, expand=1)
	self.Host = Entry(self.Root, name='host')
	self.Host.pack(fill=X, expand=1)
	self.Host.insert(0, self.ldict['host'])
	lport = Label(self.Root, name='lport', anchor=W, text='Port:')
	lport.pack(fill=X, expand=1)
	self.Port = Entry(self.Root, name='port')
	self.Port.pack(fill=X, expand=1)
	self.Port.insert(0, self.ldict['port'])

	# Create player info section.
	lcoun = Label(self.Root, name='lcoun', anchor=W, text='Country:')
	lcoun.pack(fill=X, expand=1)
	self.Coun = Entry(self.Root, name='coun')
	self.Coun.pack(fill=X, expand=1)
	self.Coun.insert(0, self.ldict['coun'])
	lrep = Label(self.Root, name='lrep', anchor=W, text='Password:')
	lrep.pack(fill=X, expand=1)
	self.Rep = Entry(self.Root, name='rep')
	self.Rep.pack(fill=X, expand=1)
	self.Rep.insert(0, self.ldict['repr'])
	self.killV = StringVar()
	killCB = Checkbutton(self.Root, name='kill', text="Kill",
			     variable=self.killV,
			     command=self.DoKill)
	killCB.pack(anchor=W)
	self.PlayB = Button(self.Root, name='play',
			    text='Play', command=self.DoPlay)
	self.PlayB.pack(side=RIGHT)

    def DoPlay(self, event=None):
	try: port = string.atoi(self.Port.get())
	except ValueError:
	    self.Status['text'] = 'Could not convert port to an integer.'
	    return
	self.ldict.update({'host':self.Host.get(),
			   'port':port,
			   'coun':self.Coun.get(),
			   'repr':self.Rep.get()})
	self.Status['text'] = "Attempting connection.."
	self.loginHandler.retry()

    def DoKill(self):
	self.login_kill = self.killV.get() == "1"

    def handleDelete(self):
	self.Root.withdraw()

    def login_error(self, msg):
	"""Login handler: Called when a login error occurs"""
	self.Status['text'] = msg
	self.Root.deiconify()
	self.Root.lift()

    def login_success(self):
	"""Login handler: Called upon a successful login"""
	self.Root.withdraw()

    def connect_success(self):
	"""Login handler: Called when the server connects"""
	viewer.startConn()
	self.Host['state'] = DISABLED
	self.Port['state'] = DISABLED

    def connect_terminate(self):
	"""Login handler: Called when the server disconnects"""
	viewer.stopConn()
