/*-------------------------------------------------------------------------*/
/* menudefs.h								   */
/* Copyright (c) 1998  Tim Edwards, Johns Hopkins University        	   */
/*-------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
/* Menu Definitions for hierarchical pulldown menus                        */
/*-------------------------------------------------------------------------*/

typedef struct _menustruct *menuptr;

typedef struct _menustruct {
        char *name;
        menuptr submenu;
        short size;
        XtCallbackProc func;
        void *passeddata;
} menustruct;

/*-------------------------------------------------------------------------*/
/* Functions declared externally to the menu structures			   */
/* (A list of every function called from the menu buttons)		   */
/*-------------------------------------------------------------------------*/

extern Clientdata areastruct;
extern object	areaobject;

extern XtCallbackProc DoNothing(), toggle(), getint(), getfloat(), quit();
extern XtCallbackProc getstr(), drawarea(), zoomin(), zoomout(), centerpan();
extern XtCallbackProc startdelete(), startcatalog(), startrotate();
extern XtCallbackProc drawuser(), placedot(), getfile();
extern XtCallbackProc startbox(), startcopy(), starttext();
extern XtCallbackProc zoomview(), saveas(), startarc(), sethjust(), setvjust();
extern XtCallbackProc setflipinv(), getfill(), getset(), getopaque(), join();
extern XtCallbackProc addnewfont(), setfont(), fontstyle(), newpagemenu();
extern XtCallbackProc getline(), startpush(), popobject(), resetbutton(), gettsize();
extern XtCallbackProc selectsave(), addtotext(), dooutput(), undelete(), getosize();
extern XtCallbackProc getwirewidth(), getwwidth(), getlib(), savelib(), getuserlib();
extern XtCallbackProc startdesel(), starthelp(), getdscale(), startspline();
extern XtCallbackProc getgridtype(), zoombox(), startedit(), startman(), boxedit(); 
extern XtCallbackProc inversecolor(), addnewcolor(), setcolor();
#ifdef SCHEMA
extern XtCallbackProc swapschem(), callgennet(), makefund(), dopinglobal();
#endif

/*-------------------------------------------------------------------------*/
